package slimeknights.tconstruct.shared.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;

import java.util.Random;

import slimeknights.tconstruct.smeltery.block.BlockTinkerFluid;
import slimeknights.tconstruct.world.TinkerWorld;

public class BlockLiquidSlime extends BlockTinkerFluid {

  public BlockLiquidSlime(Fluid fluid, Material material) {
    super(fluid, material);
  }

  @Override
  public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
    int oldLevel = state.func_177229_b(LEVEL);
    super.func_180650_b(world, pos, state, rand);

    // no fluid update but flowing?
    if(oldLevel > 0 && oldLevel == state.func_177229_b(LEVEL)) {
      if(rand.nextFloat() > 0.6f) {
        // only if they have dirt below them
        Block blockDown = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if(blockDown == Blocks.field_150346_d) {
          // check if the block we flowed from has slimedirt below it and move the slime with us!
          for(EnumFacing dir : EnumFacing.field_176754_o) {
            IBlockState state2 = world.func_180495_p(pos.func_177972_a(dir));
            // same block and a higher flow
            if(state2.func_177230_c() == this && state2.func_177229_b(LEVEL) == state.func_177229_b(LEVEL) - 1) {
              IBlockState dirt = world.func_180495_p(pos.func_177972_a(dir).func_177977_b());
              if(dirt.func_177230_c() == TinkerWorld.slimeDirt) {
                // we got a block we flowed from and the block we flowed from has slimedirt below
                // change the dirt below us to slimedirt too
                world.func_175656_a(pos.func_177977_b(), dirt);
              }
              if(dirt.func_177230_c() == TinkerWorld.slimeGrass) {
                world.func_175656_a(pos.func_177977_b(), TinkerWorld.slimeGrass.getDirtState(dirt));
              }
            }
          }
        }
      }

      world.func_180497_b(pos, this, 400 + rand.nextInt(200), 0);
    }
  }

  @Override
  public boolean canCreatureSpawn(IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
    if(type == EntityLiving.SpawnPlacementType.IN_WATER) {
      return true;
    }

    return super.canCreatureSpawn(world, pos, type);
  }
}
