package slimeknights.tconstruct.shared;

import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.stats.AchievementList;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.Mattock;
import slimeknights.tconstruct.tools.item.Pickaxe;

public class AchievementEvents {

  @SubscribeEvent
  public void onCraft(PlayerEvent.ItemCraftedEvent event) {
    if(event.player == null || event.crafting == null) {
      return;
    }
    Item item = event.crafting.func_77973_b();
    // fire vanilla pickaxe crafting when crafting tinkers picks (hammers also count for completeness sake)
    if(item instanceof Pickaxe) {
      event.player.func_71029_a(AchievementList.field_76018_i);

      if(TagUtil.getToolStats(event.crafting).harvestLevel > 0) {
        event.player.func_71029_a(AchievementList.field_76012_o);
      }
    }
    if(item instanceof Mattock) {
      event.player.func_71029_a(AchievementList.field_76013_l);
    }
    // sword == basic weapon achievement. Any weapon besides hatchet
    if(item != TinkerTools.hatchet && item instanceof ToolCore && ((ToolCore) item).hasCategory(Category.WEAPON)) {
      event.player.func_71029_a(AchievementList.field_76024_r);
    }
  }

  @SubscribeEvent
  public void onSmelted(PlayerEvent.ItemSmeltedEvent event) {
    if(event.player == null || event.smelting == null) {
      return;
    }

    Item item = event.smelting.func_77973_b();
    if(item == Items.field_151042_j) {
      event.player.func_71029_a(AchievementList.field_76016_k);
    }
  }

  // todo: bow
}
