/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockTallSlimeGrass;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockSlimeGrass
extends BlockGrass {
    public static PropertyEnum<DirtType> TYPE = PropertyEnum.create((String)"type", DirtType.class);
    public static PropertyEnum<FoliageType> FOLIAGE = PropertyEnum.create((String)"foliage", FoliageType.class);

    public BlockSlimeGrass() {
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabWorld);
        this.setHardness(0.65f);
        this.setStepSound(soundTypeGrass);
        this.slipperiness += 0.05f;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (FoliageType grass : FoliageType.values()) {
            for (DirtType type : DirtType.values()) {
                list.add(new ItemStack((Block)this, 1, this.getMetaFromState(this.getDefaultState().withProperty(TYPE, (Comparable)((Object)type)).withProperty(FOLIAGE, (Comparable)((Object)grass)))));
            }
        }
    }

    public void grow(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        BlockPos blockpos1 = pos.up();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos2 = blockpos1;
            for (int j = 0; j < i / 16; ++j) {
                if (worldIn.getBlockState((blockpos2 = blockpos2.add(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).down()).getBlock() != this || worldIn.getBlockState(blockpos2).getBlock().isNormalCube()) continue block0;
            }
            if (!worldIn.isAirBlock(blockpos2)) continue;
            IBlockState plantState = rand.nextInt(8) == 0 ? TinkerWorld.slimeGrassTall.getDefaultState().withProperty(BlockTallSlimeGrass.TYPE, (Comparable)((Object)BlockTallSlimeGrass.SlimePlantType.FERN)) : TinkerWorld.slimeGrassTall.getDefaultState().withProperty(BlockTallSlimeGrass.TYPE, (Comparable)((Object)BlockTallSlimeGrass.SlimePlantType.TALL_GRASS));
            if (!TinkerWorld.slimeGrassTall.canBlockStay(worldIn, blockpos2, plantState = plantState.withProperty(BlockTallSlimeGrass.FOLIAGE, state.getValue(FOLIAGE)))) continue;
            worldIn.setBlockState(blockpos2, plantState, 3);
        }
    }

    public void updateTick(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.isRemote) {
            return;
        }
        if (worldIn.getLightFromNeighbors(pos.up()) < 4 && worldIn.getBlockState(pos.up()).getBlock().getLightOpacity((IBlockAccess)worldIn, pos.up()) > 2) {
            worldIn.setBlockState(pos, this.getDirtState(state));
        } else if (worldIn.getLightFromNeighbors(pos.up()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos pos1 = pos.add(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                Block block = worldIn.getBlockState(pos1.up()).getBlock();
                IBlockState state1 = worldIn.getBlockState(pos1);
                if (worldIn.getLightFromNeighbors(pos1.up()) < 4 || block.getLightOpacity((IBlockAccess)worldIn, pos1.up()) > 2) continue;
                this.convert(worldIn, pos1, state1, (FoliageType)((Object)state.getValue(FOLIAGE)));
            }
        }
    }

    public void convert(World world, BlockPos pos, IBlockState state, FoliageType foliageType) {
        IBlockState newState = this.getStateFromDirt(state);
        if (newState != null) {
            world.setBlockState(pos, newState.withProperty(FOLIAGE, (Comparable)((Object)foliageType)));
        }
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{TYPE, FOLIAGE, BlockGrass.SNOWY});
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta > 14) {
            meta = 0;
        }
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)DirtType.values()[meta % 5])).withProperty(FOLIAGE, (Comparable)((Object)FoliageType.values()[meta / 5]));
    }

    public int getMetaFromState(IBlockState state) {
        DirtType type = (DirtType)((Object)state.getValue(TYPE));
        FoliageType grass = (FoliageType)((Object)state.getValue(FOLIAGE));
        return type.ordinal() + grass.ordinal() * 5;
    }

    public int damageDropped(IBlockState state) {
        DirtType type = (DirtType)((Object)state.getValue(TYPE));
        if (type == DirtType.VANILLA) {
            return 0;
        }
        return ((BlockSlimeDirt.DirtType)((Object)this.getDirtState(state).getValue(BlockSlimeDirt.TYPE))).getMeta();
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this.getDirtState(state).getBlock());
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
        return this.createStackedBlock(world.getBlockState(pos));
    }

    public IBlockState getDirtState(IBlockState grassState) {
        DirtType type = (DirtType)((Object)grassState.getValue(TYPE));
        switch (type) {
            case VANILLA: {
                return Blocks.dirt.getDefaultState();
            }
            case GREEN: {
                return TinkerWorld.slimeDirt.getStateFromMeta(BlockSlimeDirt.DirtType.GREEN.getMeta());
            }
            case BLUE: {
                return TinkerWorld.slimeDirt.getStateFromMeta(BlockSlimeDirt.DirtType.BLUE.getMeta());
            }
            case PURPLE: {
                return TinkerWorld.slimeDirt.getStateFromMeta(BlockSlimeDirt.DirtType.PURPLE.getMeta());
            }
            case MAGMA: {
                return TinkerWorld.slimeDirt.getStateFromMeta(BlockSlimeDirt.DirtType.MAGMA.getMeta());
            }
        }
        return TinkerWorld.slimeDirt.getStateFromMeta(BlockSlimeDirt.DirtType.GREEN.getMeta());
    }

    public IBlockState getStateFromDirt(IBlockState dirtState) {
        if (dirtState.getBlock() == Blocks.dirt && dirtState.getValue((IProperty)BlockDirt.VARIANT) == BlockDirt.DirtType.DIRT) {
            return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)DirtType.VANILLA));
        }
        if (dirtState.getBlock() == TinkerWorld.slimeDirt) {
            if (dirtState.getValue(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.GREEN) {
                return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)DirtType.GREEN));
            }
            if (dirtState.getValue(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.BLUE) {
                return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)DirtType.BLUE));
            }
            if (dirtState.getValue(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.PURPLE) {
                return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)DirtType.PURPLE));
            }
            if (dirtState.getValue(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.MAGMA) {
                return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)DirtType.MAGMA));
            }
        }
        return null;
    }

    public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        return plantable.getPlantType(world, pos) == TinkerWorld.slimePlantType || plantable.getPlantType(world, pos) == EnumPlantType.Plains;
    }

    public int getBlockColor() {
        return SlimeColorizer.colorBlue;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColor(IBlockState state) {
        FoliageType foliageType = (FoliageType)((Object)state.getValue(FOLIAGE));
        return SlimeColorizer.getColorStatic(foliageType);
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockAccess worldIn, BlockPos pos, int renderPass) {
        IBlockState state = worldIn.getBlockState(pos);
        if (state.getBlock() != this) {
            return this.getBlockColor();
        }
        FoliageType foliageType = (FoliageType)((Object)state.getValue(FOLIAGE));
        return SlimeColorizer.getColorForPos(pos, foliageType);
    }

    public static enum DirtType implements IStringSerializable
    {
        VANILLA,
        GREEN,
        BLUE,
        PURPLE,
        MAGMA;


        public String getName() {
            return this.toString();
        }
    }

    public static enum FoliageType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        BLUE,
        PURPLE,
        ORANGE;


        public static FoliageType getValFromMeta(int meta) {
            if (meta < 0 || meta >= FoliageType.values().length) {
                meta = 0;
            }
            return FoliageType.values()[meta];
        }

        public int getMeta() {
            return this.ordinal();
        }

        public String getName() {
            return this.toString();
        }
    }
}

