/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;

public class BlockSlime
extends net.minecraft.block.BlockSlime {
    public static final PropertyEnum<SlimeType> TYPE = PropertyEnum.create((String)"type", SlimeType.class);

    public BlockSlime() {
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabWorld);
        this.disableStats();
        this.setStepSound(SLIME_SOUND);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (SlimeType type : SlimeType.values()) {
            list.add(new ItemStack((Block)this, 1, type.meta));
        }
    }

    protected BlockState createBlockState() {
        return new BlockState((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TYPE, (Comparable)((Object)SlimeType.fromMeta(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((SlimeType)((Object)state.getValue(BlockSlime.TYPE))).meta;
    }

    public int damageDropped(IBlockState state) {
        return this.getMetaFromState(state);
    }

    public static enum SlimeType implements IStringSerializable
    {
        GREEN,
        BLUE,
        PURPLE,
        BLOOD,
        MAGMA;

        public final int meta = this.ordinal();

        public static SlimeType fromMeta(int meta) {
            if (meta < 0 || meta >= SlimeType.values().length) {
                meta = 0;
            }
            return SlimeType.values()[meta];
        }

        public String getName() {
            return this.toString();
        }
    }
}

