/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public class TraitShocking
extends AbstractTrait {
    public TraitShocking() {
        super("shocking", 0xFFFFFF);
    }

    @Override
    public void onHit(ItemStack tool, EntityLivingBase player, EntityLivingBase target, float damage, boolean isCritical) {
        if (player.worldObj.isRemote) {
            return;
        }
        NBTTagCompound tag = TinkerUtil.getModifierTag(tool, this.identifier);
        Data data = Data.read(tag);
        if (data.charge >= 100.0f && TraitShocking.attackEntitySecondary((DamageSource)new EntityDamageSource("lightningBolt", (Entity)player), 5.0f, (Entity)target, false, true, false)) {
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).worldObj.playSoundEffect(player.posX, player.posY, player.posZ, Sounds.shocking_discharge, 2.0f, 1.0f);
            }
            data.charge = 0.0f;
            NBTTagList tagList = TagUtil.getModifiersTagList(tool);
            int index = TinkerUtil.getIndexInCompoundList(tagList, this.identifier);
            data.write(tag);
            tagList.set(index, (NBTBase)tag);
            TagUtil.setModifiersTagList(tool, tagList);
            TagUtil.setEnchantEffect(tool, false);
        }
    }

    @Override
    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!isSelected || world.isRemote) {
            return;
        }
        NBTTagList tagList = TagUtil.getModifiersTagList(tool);
        int index = TinkerUtil.getIndexInCompoundList(tagList, this.identifier);
        NBTTagCompound tag = tagList.getCompoundTagAt(index);
        Data data = Data.read(tag);
        if (data.charge >= 100.0f) {
            return;
        }
        double dx = entity.posX - data.x;
        double dy = entity.posY - data.y;
        double dz = entity.posZ - data.z;
        double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (dist < (double)0.1f) {
            return;
        }
        if (dist > 5.0) {
            dist = 5.0;
        }
        data.charge = (float)((double)data.charge + dist * 2.0);
        if (data.charge >= 100.0f) {
            TagUtil.setEnchantEffect(tool, true);
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).playerNetServerHandler.sendPacket((Packet)new S29PacketSoundEffect(Sounds.shocking_charged, entity.posX, entity.posY, entity.posZ, 1.0f, 0.8f + 0.2f * random.nextFloat()));
            }
        }
        data.x = entity.posX;
        data.y = entity.posY;
        data.z = entity.posZ;
        data.write(tag);
        tagList.set(index, (NBTBase)tag);
        TagUtil.setModifiersTagList(tool, tagList);
    }

    public static class Data {
        float charge;
        double x;
        double y;
        double z;

        public static Data read(NBTTagCompound tag) {
            Data data = new Data();
            data.charge = tag.getFloat("charge");
            data.x = tag.getDouble("x");
            data.y = tag.getDouble("y");
            data.z = tag.getDouble("z");
            return data;
        }

        public void write(NBTTagCompound tag) {
            tag.setFloat("charge", this.charge);
            tag.setDouble("x", this.x);
            tag.setDouble("y", this.y);
            tag.setDouble("z", this.z);
        }
    }
}

