/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.utils.TagUtil;

public abstract class TraitProgressiveStats
extends AbstractTrait {
    protected final String pool_key;
    protected final String applied_key;

    public TraitProgressiveStats(String identifier, EnumChatFormatting color) {
        super(identifier, color);
        this.pool_key = identifier + "StatPool";
        this.applied_key = identifier + "StatBonus";
    }

    public TraitProgressiveStats(String identifier, int color) {
        super(identifier, color);
        this.pool_key = identifier + "StatPool";
        this.applied_key = identifier + "StatBonus";
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        super.applyEffect(rootCompound, modifierTag);
        ToolNBT data = TagUtil.getToolStats(rootCompound);
        StatNBT bonus = this.getBonus(rootCompound);
        data.durability += bonus.durability;
        data.speed += bonus.speed;
        data.attack += bonus.attack;
        TagUtil.setToolTag(rootCompound, data.get());
    }

    protected boolean hasPool(NBTTagCompound root) {
        return TagUtil.getExtraTag(root).hasKey(this.pool_key);
    }

    protected StatNBT getPool(NBTTagCompound root) {
        return TraitProgressiveStats.getStats(root, this.pool_key);
    }

    protected void setPool(NBTTagCompound root, StatNBT data) {
        TraitProgressiveStats.setStats(root, data, this.pool_key);
    }

    protected StatNBT getBonus(NBTTagCompound root) {
        return TraitProgressiveStats.getStats(root, this.applied_key);
    }

    protected void setBonus(NBTTagCompound root, StatNBT data) {
        TraitProgressiveStats.setStats(root, data, this.applied_key);
    }

    protected static StatNBT getStats(NBTTagCompound root, String key) {
        return ModifierNBT.readTag(TagUtil.getTagSafe(TagUtil.getExtraTag(root), key), StatNBT.class);
    }

    protected static void setStats(NBTTagCompound root, StatNBT data, String key) {
        NBTTagCompound extra = TagUtil.getExtraTag(root);
        NBTTagCompound tag = new NBTTagCompound();
        data.write(tag);
        extra.setTag(key, (NBTBase)tag);
        TagUtil.setExtraTag(root, extra);
    }

    protected boolean playerIsBreakingBlock(Entity entity) {
        return entity instanceof EntityPlayerMP ? ((EntityPlayerMP)entity).theItemInWorldManager.isDestroyingBlock : entity instanceof EntityPlayerSP && Minecraft.getMinecraft().playerController.isHittingBlock;
    }

    public static class StatNBT
    extends ModifierNBT {
        public int durability;
        public float attack;
        public float speed;

        @Override
        public void read(NBTTagCompound tag) {
            super.read(tag);
            this.durability = tag.getInteger("durability");
            this.attack = tag.getFloat("attack");
            this.speed = tag.getFloat("speed");
        }

        @Override
        public void write(NBTTagCompound tag) {
            super.write(tag);
            tag.setInteger("durability", this.durability);
            tag.setFloat("attack", this.attack);
            tag.setFloat("speed", this.speed);
        }
    }
}

