/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.WorldServer;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.tools.client.GuiToolStation;
import slimeknights.tconstruct.tools.inventory.ContainerToolStation;

public class ToolStationSelectionPacket
extends AbstractPacketThreadsafe {
    public ToolCore tool;
    public int activeSlots;

    public ToolStationSelectionPacket() {
    }

    public ToolStationSelectionPacket(ToolCore tool, int activeSlots) {
        this.tool = tool;
        this.activeSlots = activeSlots;
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        Container container = Minecraft.getMinecraft().thePlayer.openContainer;
        if (container instanceof ContainerToolStation) {
            ((ContainerToolStation)container).setToolSelection(this.tool, this.activeSlots);
            if (Minecraft.getMinecraft().currentScreen instanceof GuiToolStation) {
                ((GuiToolStation)Minecraft.getMinecraft().currentScreen).onToolSelectionPacket(this);
            }
        }
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        Container container = netHandler.playerEntity.openContainer;
        if (container instanceof ContainerToolStation) {
            ((ContainerToolStation)container).setToolSelection(this.tool, this.activeSlots);
            WorldServer server = netHandler.playerEntity.getServerForPlayer();
            for (EntityPlayer player : server.playerEntities) {
                if (player == netHandler.playerEntity || !(player.openContainer instanceof ContainerToolStation) || !((BaseContainer)container).sameGui((BaseContainer)player.openContainer)) continue;
                ((ContainerToolStation)player.openContainer).setToolSelection(this.tool, this.activeSlots);
                TinkerNetwork.sendTo((AbstractPacket)this, (EntityPlayerMP)player);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        Item item;
        short id = buf.readShort();
        if (id > -1 && (item = Item.getItemById((int)id)) instanceof ToolCore) {
            this.tool = (ToolCore)item;
        }
        this.activeSlots = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        if (this.tool == null) {
            buf.writeShort(-1);
        } else {
            buf.writeShort(Item.getIdFromItem((Item)this.tool));
        }
        buf.writeInt(this.activeSlots);
    }
}

