/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.tools.TinkerTools;

public class Pickaxe
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.iron, (Object)Material.anvil, (Object)Material.rock, (Object)Material.ice, (Object)Material.glass, (Object)Material.packedIce, (Object[])new Material[]{Material.piston});

    public Pickaxe() {
        this(PartMaterialType.handle(TinkerTools.toolRod), PartMaterialType.head(TinkerTools.pickHead), PartMaterialType.extra(TinkerTools.binding));
    }

    public Pickaxe(PartMaterialType ... requiredComponents) {
        super(requiredComponents);
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems);
        this.addInfiTool(subItems, "InfiHarvester");
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.getMaterial()) || ItemPickaxe.EFFECTIVE_ON.contains(block);
    }

    @Override
    public float damagePotential() {
        return 1.0f;
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        return this.buildDefaultTag(materials).get();
    }
}

