/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import gnu.trove.set.hash.THashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.tinkering.Category;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.AoeToolCore;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.events.TinkerToolEvent;

public class LumberAxe
extends AoeToolCore {
    public static final ImmutableSet<Material> effective_materials = ImmutableSet.of((Object)Material.wood, (Object)Material.gourd, (Object)Material.cactus);

    public LumberAxe() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.broadAxeHead), PartMaterialType.head(TinkerTools.largePlate), PartMaterialType.extra(TinkerTools.toughBinding));
        this.addCategory(Category.HARVEST);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public void getSubItems(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        this.addDefaultSubItems(subItems);
        this.addInfiTool(subItems, "InfiChopper");
    }

    @Override
    public float miningSpeedModifier() {
        return 0.35f;
    }

    @Override
    public float damagePotential() {
        return 0.9f;
    }

    @Override
    public boolean isEffective(Block block) {
        return effective_materials.contains((Object)block.getMaterial()) || ItemAxe.EFFECTIVE_ON.contains(block);
    }

    @Override
    public float knockback() {
        return 1.5f;
    }

    @Override
    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        if (ToolHelper.isToolEffective2(itemstack, player.worldObj.getBlockState(pos)) && LumberAxe.detectTree(player.worldObj, pos)) {
            return LumberAxe.fellTree(itemstack, pos, player);
        }
        return super.onBlockStartBreak(itemstack, pos, player);
    }

    @Override
    public ImmutableList<BlockPos> getAOEBlocks(ItemStack stack, World world, EntityPlayer player, BlockPos origin) {
        if (!ToolHelper.isToolEffective2(stack, world.getBlockState(origin))) {
            return ImmutableList.of();
        }
        return ToolHelper.calcAOEBlocks(stack, world, player, origin, 3, 3, 3);
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public NBTTagCompound buildTag(List<slimeknights.tconstruct.library.materials.Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats plate = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats binding = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(head, plate);
        data.extra(binding);
        data.handle(handle);
        data.durability = (int)((float)data.durability * 2.0f);
        data.modifiers = 2;
        return data.get();
    }

    public static boolean detectTree(World world, BlockPos origin) {
        BlockPos pos = null;
        Stack<BlockPos> candidates = new Stack<BlockPos>();
        candidates.add(origin);
        while (!candidates.isEmpty()) {
            BlockPos candidate = (BlockPos)candidates.pop();
            if (pos != null && candidate.getY() <= pos.getY() || !LumberAxe.isLog(world, candidate)) continue;
            pos = candidate.up();
            while (LumberAxe.isLog(world, pos)) {
                pos = pos.up();
            }
            candidates.add(pos.north());
            candidates.add(pos.east());
            candidates.add(pos.south());
            candidates.add(pos.west());
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int o = -1;
        int leaves = 0;
        for (int x = 0; x < d; ++x) {
            for (int y = 0; y < d; ++y) {
                for (int z = 0; z < d; ++z) {
                    BlockPos leaf = pos.add(o + x, o + y, o + z);
                    if (!world.getBlockState(leaf).getBlock().isLeaves((IBlockAccess)world, leaf) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLog(World world, BlockPos pos) {
        return world.getBlockState(pos).getBlock().isWood((IBlockAccess)world, pos);
    }

    public static boolean fellTree(ItemStack itemstack, BlockPos start, EntityPlayer player) {
        if (player.worldObj.isRemote) {
            return true;
        }
        TinkerToolEvent.ExtraBlockBreak event = TinkerToolEvent.ExtraBlockBreak.fireEvent(itemstack, player, 3, 3, 3, -1);
        int speed = Math.round((float)(event.width * event.height * event.depth) / 27.0f);
        if (event.distance > 0) {
            speed = event.distance + 1;
        }
        MinecraftForge.EVENT_BUS.register((Object)new TreeChopTask(itemstack, start, player, speed));
        return true;
    }

    public static class TreeChopTask {
        public final World world;
        public final EntityPlayer player;
        public final ItemStack tool;
        public final int blocksPerTick;
        public Queue<BlockPos> blocks = Lists.newLinkedList();
        public Set<BlockPos> visited = new THashSet();

        public TreeChopTask(ItemStack tool, BlockPos start, EntityPlayer player, int blocksPerTick) {
            this.world = player.getEntityWorld();
            this.player = player;
            this.tool = tool;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start);
        }

        @SubscribeEvent
        public void chopChop(TickEvent.WorldTickEvent event) {
            if (event.side.isClient()) {
                this.finish();
                return;
            }
            int left = this.blocksPerTick;
            while (left > 0) {
                if (this.blocks.isEmpty() || ToolHelper.isBroken(this.tool)) {
                    this.finish();
                    return;
                }
                BlockPos pos = this.blocks.remove();
                if (!this.visited.add(pos) || !LumberAxe.isLog(this.world, pos) || !ToolHelper.isToolEffective2(this.tool, this.world.getBlockState(pos))) continue;
                for (EnumFacing facing : new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST}) {
                    BlockPos pos2 = pos.offset(facing);
                    if (this.visited.contains(pos2)) continue;
                    this.blocks.add(pos2);
                }
                for (int x = 0; x < 3; ++x) {
                    for (int z = 0; z < 3; ++z) {
                        BlockPos pos2 = pos.add(-1 + x, 1, -1 + z);
                        if (this.visited.contains(pos2)) continue;
                        this.blocks.add(pos2);
                    }
                }
                ToolHelper.breakExtraBlock(this.tool, this.world, this.player, pos, pos);
                --left;
            }
        }

        private void finish() {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }
}

