/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.events;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.tools.ToolCore;

public abstract class TinkerToolEvent
extends TinkerEvent {
    public final ItemStack itemStack;
    public final ToolCore tool;

    public TinkerToolEvent(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.tool = (ToolCore)itemStack.getItem();
    }

    public static class OnRepair
    extends TinkerToolEvent {
        public final int amount;

        public OnRepair(ItemStack itemStack, int amount) {
            super(itemStack);
            this.amount = amount;
        }

        public static boolean fireEvent(ItemStack itemStack, int amount) {
            OnRepair event = new OnRepair(itemStack, amount);
            return !MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    public static class ExtraBlockBreak
    extends TinkerToolEvent {
        public final EntityPlayer player;
        public int width;
        public int height;
        public int depth;
        public int distance;

        public ExtraBlockBreak(ItemStack itemStack, EntityPlayer player) {
            super(itemStack);
            this.player = player;
        }

        public static ExtraBlockBreak fireEvent(ItemStack itemStack, EntityPlayer player, int width, int height, int depth, int distance) {
            ExtraBlockBreak event = new ExtraBlockBreak(itemStack, player);
            event.width = width;
            event.height = height;
            event.depth = depth;
            event.distance = distance;
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event;
        }
    }
}

