/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client.module;

import com.google.common.collect.Lists;
import gnu.trove.list.TIntList;
import gnu.trove.list.linked.TIntLinkedList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.client.gui.GuiWidgetSlider;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tools.client.module.GuiWidgetBorder;

public class GuiInfoPanel
extends GuiModule {
    private static int resW = 118;
    private static int resH = 75;
    private static ResourceLocation BACKGROUND = Util.getResource("textures/gui/panel.png");
    private static GuiElement topLeft = new GuiElement(0, 0, 4, 4, 256, 256);
    private static GuiElement topRight = new GuiElement(resW + 4, 0, 4, 4);
    private static GuiElement botLeft = new GuiElement(0, resH + 4, 4, 4);
    private static GuiElement botRight = new GuiElement(resW + 4, resH + 4, 4, 4);
    private static GuiElementScalable top = new GuiElementScalable(4, 0, resW, 4);
    private static GuiElementScalable bot = new GuiElementScalable(4, 4 + resH, resW, 4);
    private static GuiElementScalable left = new GuiElementScalable(0, 4, 4, resH);
    private static GuiElementScalable right = new GuiElementScalable(4 + resW, 4, 4, resH);
    private static GuiElementScalable background = new GuiElementScalable(4, 4, resW, resH);
    private static GuiElement sliderNormal = new GuiElement(0, 83, 3, 5);
    private static GuiElement sliderHover = sliderNormal.shift(GuiInfoPanel.sliderNormal.w, 0);
    private static GuiElementScalable sliderBar = new GuiElementScalable(0, 88, 3, 8);
    private static GuiElement sliderTop = new GuiElement(3, 88, 3, 4);
    private static GuiElement sliderBot = new GuiElement(3, 92, 3, 4);
    private GuiWidgetBorder border = new GuiWidgetBorder();
    private FontRenderer fontRenderer = ClientProxy.fontRenderer;
    private GuiWidgetSlider slider = new GuiWidgetSlider(sliderNormal, sliderHover, sliderHover, sliderTop, sliderBot, sliderBar);
    protected String caption;
    protected List<String> text;
    protected List<String> tooltips;
    private TIntList tooltipLines = new TIntLinkedList();
    public float textScale = 1.0f;

    public GuiInfoPanel(GuiMultiModule parent, Container container) {
        super(parent, container, true, false);
        this.border.borderTop = top;
        this.border.borderBottom = bot;
        this.border.borderLeft = left;
        this.border.borderRight = right;
        this.border.cornerTopLeft = topLeft;
        this.border.cornerTopRight = topRight;
        this.border.cornerBottomLeft = botLeft;
        this.border.cornerBottomRight = botRight;
        this.xSize = resW + 8;
        this.ySize = resH + 8;
        this.caption = "Caption";
        this.text = Lists.newLinkedList();
        this.fontRendererObj = this.fontRenderer;
    }

    public void setWorldAndResolution(Minecraft mc, int width, int height) {
        super.setWorldAndResolution(mc, width, height);
        this.fontRendererObj = this.fontRenderer;
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        this.border.setPosition(this.guiLeft, this.guiTop);
        this.border.setSize(this.xSize, this.ySize);
        this.slider.setPosition(this.guiRight() - this.border.w - 2, this.guiTop + this.border.h + 12);
        this.slider.setSize(this.ySize - this.border.h * 2 - 2 - 12);
        this.updateSliderParameters();
    }

    public void setCaption(String caption) {
        this.caption = caption;
        this.updateSliderParameters();
    }

    public void setText(String ... text) {
        this.setText(Lists.newArrayList((Object[])text), null);
    }

    public void setText(List<String> text) {
        this.setText(text, null);
    }

    public void setText(List<String> text, List<String> tooltips) {
        if (text != null) {
            for (int i = 0; i < text.size(); ++i) {
                text.set(i, Util.convertNewlines(text.get(i)));
            }
        }
        this.text = text;
        this.updateSliderParameters();
        this.setTooltips(tooltips);
    }

    protected void setTooltips(List<String> tooltips) {
        if (tooltips != null) {
            for (int i = 0; i < tooltips.size(); ++i) {
                tooltips.set(i, Util.convertNewlines(tooltips.get(i)));
            }
        }
        this.tooltips = tooltips;
    }

    public boolean hasCaption() {
        return this.caption != null && !this.caption.isEmpty();
    }

    public boolean hasTooltips() {
        return this.tooltips != null && !this.tooltips.isEmpty();
    }

    public int calcNeededHeight() {
        int neededHeight = 0;
        if (this.hasCaption()) {
            neededHeight += this.fontRenderer.FONT_HEIGHT;
            neededHeight += 3;
        }
        neededHeight = (int)((float)neededHeight + ((float)this.fontRenderer.FONT_HEIGHT + 0.5f) * (float)this.getTotalLines().size());
        return neededHeight;
    }

    protected void updateSliderParameters() {
        this.slider.hide();
        int h = this.ySize - 10;
        if (this.calcNeededHeight() <= h) {
            return;
        }
        this.slider.show();
        int neededHeight = this.calcNeededHeight();
        int hiddenRows = (neededHeight - h) / this.fontRenderer.FONT_HEIGHT;
        if ((neededHeight - h) % this.fontRenderer.FONT_HEIGHT > 0) {
            ++hiddenRows;
        }
        this.slider.setSliderParameters(0, hiddenRows, 1);
    }

    protected List<String> getTotalLines() {
        int w = this.xSize - this.border.w * 2 + 2;
        if (!this.slider.isHidden()) {
            w -= this.slider.width + 3;
        }
        w = (int)((float)w / this.textScale);
        LinkedList lines = Lists.newLinkedList();
        this.tooltipLines.clear();
        for (String line : this.text) {
            this.tooltipLines.add(lines.size());
            if (line == null || line.isEmpty()) {
                lines.add("");
                continue;
            }
            lines.addAll(this.fontRenderer.listFormattedStringToWidth(line, w));
        }
        return lines;
    }

    public GuiInfoPanel wood() {
        this.shift(resW + 8, 0);
        this.shiftSlider(6, 0);
        return this;
    }

    public GuiInfoPanel metal() {
        this.shift(resW + 8, resH + 8);
        this.shiftSlider(12, 0);
        return this;
    }

    private void shift(int xd, int yd) {
        this.border.borderTop = top.shift(xd, yd);
        this.border.borderBottom = bot.shift(xd, yd);
        this.border.borderLeft = left.shift(xd, yd);
        this.border.borderRight = right.shift(xd, yd);
        this.border.cornerTopLeft = topLeft.shift(xd, yd);
        this.border.cornerTopRight = topRight.shift(xd, yd);
        this.border.cornerBottomLeft = botLeft.shift(xd, yd);
        this.border.cornerBottomRight = botRight.shift(xd, yd);
    }

    private void shiftSlider(int xd, int yd) {
        this.slider = new GuiWidgetSlider(sliderNormal.shift(xd, yd), sliderHover.shift(xd, yd), sliderHover.shift(xd, yd), sliderTop.shift(xd, yd), sliderBot.shift(xd, yd), sliderBar.shift(xd, yd));
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int i;
        if (this.tooltips == null) {
            return;
        }
        if (mouseX < this.guiLeft || mouseX > this.guiRight()) {
            return;
        }
        if (this.hasTooltips() && mouseX >= this.guiRight() - this.border.w - this.fontRenderer.getCharWidth('?') / 2 && mouseX < this.guiRight() && mouseY > this.guiTop + 5 && mouseY < this.guiTop + 5 + this.fontRenderer.FONT_HEIGHT) {
            int w = MathHelper.clamp_int((int)(this.width - mouseX - 12), (int)10, (int)200);
            this.drawHoveringText(this.fontRenderer.listFormattedStringToWidth(Util.translate("gui.general.hover", new Object[0]), w), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
        float y = 5 + this.guiTop;
        if (this.hasCaption()) {
            y += (float)(this.fontRenderer.FONT_HEIGHT + 3);
        }
        float textHeight = (float)this.fontRenderer.FONT_HEIGHT * this.textScale + 0.5f;
        float lowerBound = (float)(this.guiTop + this.ySize - 5) / this.textScale;
        int index = -1;
        ListIterator<String> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight > lowerBound)) {
            if ((float)mouseY > y && (float)mouseY <= y + textHeight) {
                index = iter.nextIndex();
                break;
            }
            iter.next();
            y += textHeight;
        }
        if (index < 0) {
            return;
        }
        for (i = 0; this.tooltipLines.size() > i && index > this.tooltipLines.get(i); ++i) {
        }
        if (i >= this.tooltips.size() || this.tooltips.get(i) == null) {
            return;
        }
        int w = MathHelper.clamp_int((int)(this.width - mouseX - 12), (int)0, (int)200);
        if (w < 100) {
            mouseX -= 100 - w;
            w = 100;
        }
        List lines = this.fontRenderer.listFormattedStringToWidth(this.tooltips.get(i), w);
        this.drawHoveringText(lines, mouseX - this.guiLeft, mouseY - this.guiTop - lines.size() * this.fontRenderer.FONT_HEIGHT / 2);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.mc.getTextureManager().bindTexture(BACKGROUND);
        this.border.draw();
        background.drawScaled(this.guiLeft + 4, this.guiTop + 4, this.xSize - 8, this.ySize - 8);
        float y = 5 + this.guiTop;
        float x = 5 + this.guiLeft;
        int color = -986896;
        if (this.hasTooltips()) {
            this.fontRenderer.drawString("?", (float)(this.guiRight() - this.border.w - this.fontRenderer.getCharWidth('?') / 2), (float)(this.guiTop + 5), -10526881, false);
        }
        if (this.hasCaption()) {
            int x2 = this.xSize / 2;
            this.fontRenderer.drawStringWithShadow(EnumChatFormatting.UNDERLINE + EnumChatFormatting.getTextWithoutFormattingCodes((String)this.caption), (float)(this.guiLeft + (x2 -= this.fontRenderer.getStringWidth(this.caption) / 2)), y, color);
            y += (float)(this.fontRenderer.FONT_HEIGHT + 3);
        }
        if (this.text == null || this.text.size() == 0) {
            return;
        }
        float textHeight = (float)this.fontRenderer.FONT_HEIGHT * this.textScale + 0.5f;
        float lowerBound = (float)(this.guiTop + this.ySize - 5) / this.textScale;
        GlStateManager.scale((float)this.textScale, (float)this.textScale, (float)1.0f);
        x /= this.textScale;
        y /= this.textScale;
        ListIterator<String> iter = this.getTotalLines().listIterator(this.slider.getValue());
        while (iter.hasNext() && !(y + textHeight - 0.5f > lowerBound)) {
            String line = iter.next();
            this.fontRenderer.drawStringWithShadow(line, x, y, color);
            y += textHeight;
        }
        GlStateManager.scale((float)(1.0f / this.textScale), (float)(1.0f / this.textScale), (float)1.0f);
        this.mc.getTextureManager().bindTexture(BACKGROUND);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.slider.update(mouseX, mouseY, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule(mouseX, mouseY));
        this.slider.draw();
    }
}

