/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.IMaterialItem;
import slimeknights.tconstruct.library.tools.ToolPart;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.client.GuiTinkerStation;
import slimeknights.tconstruct.tools.client.module.GuiButtonsPartCrafter;
import slimeknights.tconstruct.tools.client.module.GuiInfoPanel;
import slimeknights.tconstruct.tools.client.module.GuiSideInventory;
import slimeknights.tconstruct.tools.inventory.ContainerPartBuilder;
import slimeknights.tconstruct.tools.inventory.ContainerPatternChest;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.tileentity.TilePartBuilder;

@SideOnly(value=Side.CLIENT)
public class GuiPartBuilder
extends GuiTinkerStation {
    private static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/partbuilder.png");
    public static final int Column_Count = 4;
    protected GuiButtonsPartCrafter buttons;
    protected GuiInfoPanel info;
    protected GuiSideInventory sideInventory;
    protected ContainerPatternChest.DynamicChestInventory chestContainer;

    public GuiPartBuilder(InventoryPlayer playerInv, World world, BlockPos pos, TilePartBuilder tile) {
        super(world, pos, (ContainerTinkerStation)tile.createContainer(playerInv, world, pos));
        if (this.inventorySlots instanceof ContainerPartBuilder) {
            ContainerPartBuilder container = (ContainerPartBuilder)this.inventorySlots;
            if (container.isPartCrafter()) {
                this.buttons = new GuiButtonsPartCrafter(this, (Container)container, container.patternChest);
                this.addModule(this.buttons);
            } else {
                this.chestContainer = (ContainerPatternChest.DynamicChestInventory)container.getSubContainer(ContainerPatternChest.DynamicChestInventory.class);
                if (this.chestContainer != null) {
                    this.sideInventory = new GuiSideInventory(this, (Container)this.chestContainer, this.chestContainer.getSlotCount(), this.chestContainer.columns);
                    this.addModule(this.sideInventory);
                }
            }
            this.info = new GuiInfoPanel(this, (Container)container);
            this.info.ySize = this.ySize;
            this.addModule(this.info);
        }
    }

    public void drawSlot(Slot slotIn) {
        ContainerPartBuilder container;
        if (this.inventorySlots instanceof ContainerPartBuilder && (container = (ContainerPartBuilder)this.inventorySlots).isPartCrafter() && slotIn.inventory == container.patternChest) {
            return;
        }
        super.drawSlot(slotIn);
    }

    public boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        ContainerPartBuilder container;
        if (this.inventorySlots instanceof ContainerPartBuilder && (container = (ContainerPartBuilder)this.inventorySlots).isPartCrafter() && slotIn.inventory == container.patternChest) {
            return false;
        }
        return super.isMouseOverSlot(slotIn, mouseX, mouseY);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(BACKGROUND);
        if (this.sideInventory != null) {
            this.sideInventory.updateSlotCount(this.chestContainer.getSizeInventory());
        }
        this.drawIconEmpty(this.container.getSlot(1), ICON_Shard);
        this.drawIconEmpty(this.container.getSlot(2), ICON_Pattern);
        this.drawIconEmpty(this.container.getSlot(3), ICON_Ingot);
        this.drawIconEmpty(this.container.getSlot(4), ICON_Block);
        super.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
    }

    @Override
    public void updateDisplay() {
        ItemStack output = this.container.getSlot(0).getStack();
        if (output != null) {
            if (output.getItem() instanceof ToolPart) {
                Material material;
                ToolPart toolPart = (ToolPart)output.getItem();
                if (!toolPart.canUseMaterial(material = toolPart.getMaterial(output))) {
                    String materialName = material.getLocalizedNameColored() + EnumChatFormatting.WHITE;
                    String error = StatCollector.translateToLocalFormatted((String)"gui.error.useless_tool_part", (Object[])new Object[]{materialName, new ItemStack((Item)toolPart).getDisplayName()});
                    this.warning(error);
                } else {
                    this.setDisplayForMaterial(material);
                }
            }
        } else {
            Material material = this.getMaterial(this.container.getSlot(3).getStack(), this.container.getSlot(4).getStack());
            if (material != null) {
                this.setDisplayForMaterial(material);
            } else {
                this.info.setCaption(this.container.getInventoryDisplayName().getFormattedText());
                this.info.setText(StatCollector.translateToLocal((String)"gui.partbuilder.info"));
            }
        }
    }

    @Override
    public void error(String message) {
        this.info.setCaption(StatCollector.translateToLocal((String)"gui.error"));
        this.info.setText(message);
    }

    @Override
    public void warning(String message) {
        this.info.setCaption(StatCollector.translateToLocal((String)"gui.warning"));
        this.info.setText(message);
    }

    public void updateButtons() {
        if (this.buttons != null) {
            Minecraft.getMinecraft().addScheduledTask(new Runnable(){

                @Override
                public void run() {
                    GuiPartBuilder.this.buttons.updatePosition(GuiPartBuilder.this.cornerX, GuiPartBuilder.this.cornerY, GuiPartBuilder.this.realWidth, GuiPartBuilder.this.realHeight);
                }
            });
        }
    }

    protected void setDisplayForMaterial(Material material) {
        this.info.setCaption(material.getLocalizedNameColored());
        LinkedList stats = Lists.newLinkedList();
        ArrayList tips = Lists.newArrayList();
        for (IMaterialStats stat : material.getAllStats()) {
            stats.add(EnumChatFormatting.UNDERLINE + stat.getLocalizedName());
            stats.addAll(stat.getLocalizedInfo());
            stats.add(null);
            tips.add(null);
            tips.addAll(stat.getLocalizedDesc());
            tips.add(null);
        }
        for (ITrait trait : material.getAllTraits()) {
            if (trait.isHidden()) continue;
            stats.add(material.getTextColor() + trait.getLocalizedName());
            tips.add(material.getTextColor() + trait.getLocalizedDesc());
        }
        if (!stats.isEmpty() && stats.get(stats.size() - 1) == null) {
            stats.remove(stats.size() - 1);
            tips.remove(tips.size() - 1);
        }
        this.info.setText(stats, tips);
    }

    protected Material getMaterial(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (stack == null || stack.getItem() == null || !(stack.getItem() instanceof IMaterialItem)) continue;
            return ((IMaterialItem)stack.getItem()).getMaterial(stack);
        }
        for (Material material : TinkerRegistry.getAllMaterials()) {
            if (material.matches(stacks) == null) continue;
            return material;
        }
        return null;
    }

    private Material getMaterialItem(ItemStack stack) {
        return null;
    }
}

