/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.block;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.tools.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.tileentity.TileCraftingStation;
import slimeknights.tconstruct.tools.tileentity.TilePartBuilder;
import slimeknights.tconstruct.tools.tileentity.TilePartChest;
import slimeknights.tconstruct.tools.tileentity.TilePatternChest;
import slimeknights.tconstruct.tools.tileentity.TileStencilTable;
import slimeknights.tconstruct.tools.tileentity.TileToolStation;

public class BlockToolTable
extends BlockTable
implements ITinkerStationBlock {
    public static final PropertyEnum<TableTypes> TABLES = PropertyEnum.create((String)"type", TableTypes.class);

    public BlockToolTable() {
        super(Material.wood);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
        this.setStepSound(soundTypeWood);
        this.setResistance(5.0f);
        this.setHardness(1.0f);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        switch (TableTypes.fromMeta(meta)) {
            case CraftingStation: {
                return new TileCraftingStation();
            }
            case StencilTable: {
                return new TileStencilTable();
            }
            case PartBuilder: {
                return new TilePartBuilder();
            }
            case ToolStation: {
                return new TileToolStation();
            }
            case PatternChest: {
                return new TilePatternChest();
            }
            case PartChest: {
                return new TilePartChest();
            }
        }
        return super.createNewTileEntity(worldIn, meta);
    }

    @Override
    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)TConstruct.instance, 0, world, pos.getX(), pos.getY(), pos.getZ());
        if (player.openContainer instanceof BaseContainer) {
            ((BaseContainer)player.openContainer).syncOnOpen((EntityPlayerMP)player);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack((Block)this, 1, TableTypes.CraftingStation.meta));
        this.addBlocksFromOredict("plankWood", TableTypes.StencilTable.meta, list);
        list.add(new ItemStack((Block)this, 1, TableTypes.PatternChest.meta));
        this.addBlocksFromOredict("logWood", TableTypes.PartBuilder.meta, list);
        list.add(new ItemStack((Block)this, 1, TableTypes.PartChest.meta));
        list.add(new ItemStack((Block)this, 1, TableTypes.ToolStation.meta));
    }

    private void addBlocksFromOredict(String oredict, int meta, List<ItemStack> list) {
        for (ItemStack stack : OreDictionary.getOres((String)oredict)) {
            Block block = BlockToolTable.getBlockFromItem((Item)stack.getItem());
            int blockMeta = stack.getItemDamage();
            if (blockMeta == Short.MAX_VALUE) {
                LinkedList subBlocks = Lists.newLinkedList();
                block.getSubBlocks(stack.getItem(), null, (List)subBlocks);
                for (ItemStack subBlock : subBlocks) {
                    list.add(BlockToolTable.createItemstack(this, meta, BlockToolTable.getBlockFromItem((Item)subBlock.getItem()), subBlock.getItemDamage()));
                }
                continue;
            }
            list.add(BlockToolTable.createItemstack(this, meta, block, blockMeta));
        }
    }

    @Override
    protected boolean keepInventory(IBlockState state) {
        return Config.chestsKeepInventory && (state.getValue(TABLES) == TableTypes.PatternChest || state.getValue(TABLES) == TableTypes.PartChest);
    }

    @Override
    protected BlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[]{TABLES}, new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    public IBlockState getStateFromMeta(int meta) {
        return this.getDefaultState().withProperty(TABLES, (Comparable)((Object)TableTypes.fromMeta(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return ((TableTypes)((Object)state.getValue(BlockToolTable.TABLES))).meta;
    }

    public void setBlockBoundsBasedOnState(IBlockAccess worldIn, BlockPos pos) {
        if (((TableTypes)((Object)worldIn.getBlockState((BlockPos)pos).getValue(BlockToolTable.TABLES))).isChest) {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 0.875f, 1.0f);
        } else {
            this.setBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public AxisAlignedBB getCollisionBoundingBox(World worldIn, BlockPos pos, IBlockState state) {
        float y = ((TableTypes)((Object)state.getValue(BlockToolTable.TABLES))).isChest ? 0.875f : 1.0f;
        return AxisAlignedBB.fromBounds((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)((float)pos.getY() + y), (double)(pos.getZ() + 1));
    }

    @Override
    public int getGuiNumber(IBlockState state) {
        switch ((TableTypes)((Object)state.getValue(TABLES))) {
            case StencilTable: {
                return 10;
            }
            case PatternChest: {
                return 15;
            }
            case PartChest: {
                return 16;
            }
            case PartBuilder: {
                return 20;
            }
            case ToolStation: {
                return 25;
            }
            case CraftingStation: {
                return 50;
            }
        }
        return 0;
    }

    public static enum TableTypes implements IStringSerializable
    {
        CraftingStation,
        StencilTable,
        PartBuilder,
        ToolStation,
        PatternChest(true),
        PartChest(true);

        public final int meta = this.ordinal();
        public final boolean isChest;

        private TableTypes() {
            this.isChest = false;
        }

        private TableTypes(boolean chest) {
            this.isChest = chest;
        }

        public static TableTypes fromMeta(int meta) {
            if (meta < 0 || meta >= TableTypes.values().length) {
                meta = 0;
            }
            return TableTypes.values()[meta];
        }

        public String getName() {
            return this.toString();
        }
    }
}

