/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.block;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.tools.block.ITinkerStationBlock;
import slimeknights.tconstruct.tools.tileentity.TileToolForge;

public class BlockToolForge
extends BlockTable
implements ITinkerStationBlock {
    public final Set<String> baseBlocks = Sets.newHashSet();

    public BlockToolForge() {
        super(Material.iron);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
        this.setStepSound(soundTypeMetal);
        this.setResistance(10.0f);
        this.setHardness(2.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public boolean openGui(EntityPlayer player, World world, BlockPos pos) {
        player.openGui((Object)TConstruct.instance, 0, world, pos.getX(), pos.getY(), pos.getZ());
        if (player.openContainer instanceof BaseContainer) {
            ((BaseContainer)player.openContainer).syncOnOpen((EntityPlayerMP)player);
        }
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileToolForge();
    }

    public void getSubBlocks(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (String oredict : this.baseBlocks) {
            List ores = OreDictionary.getOres((String)oredict);
            if (ores.size() <= 0) continue;
            list.add(BlockToolForge.createItemstack(this, 0, BlockToolForge.getBlockFromItem((Item)((ItemStack)ores.get(0)).getItem()), ((ItemStack)ores.get(0)).getItemDamage()));
        }
    }

    @Override
    protected BlockState createBlockState() {
        return new ExtendedBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{TEXTURE, INVENTORY, FACING});
    }

    @Override
    public int getGuiNumber(IBlockState state) {
        return 25;
    }
}

