/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.smeltery.block.BlockFaucet;
import slimeknights.tconstruct.smeltery.network.FaucetActivationPacket;

public class TileFaucet
extends TileEntity
implements ITickable {
    public static final int LIQUID_TRANSFER = 6;
    public static final int TRANSACTION_AMOUNT = 144;
    public EnumFacing direction;
    public boolean isPouring;
    public boolean stopPouring;
    public FluidStack drained;
    public boolean lastRedstoneState;

    public TileFaucet() {
        this.reset();
    }

    public boolean activate() {
        IBlockState state = this.worldObj.getBlockState(this.pos);
        if (!state.getPropertyNames().contains(BlockFaucet.FACING)) {
            return false;
        }
        if (this.isPouring) {
            this.stopPouring = true;
            return true;
        }
        this.direction = (EnumFacing)this.worldObj.getBlockState(this.pos).getValue((IProperty)BlockFaucet.FACING);
        this.doTransfer();
        return this.isPouring;
    }

    public void handleRedstone(boolean hasSignal) {
        if (hasSignal != this.lastRedstoneState) {
            this.lastRedstoneState = hasSignal;
            if (hasSignal) {
                this.activate();
            }
        }
    }

    public void update() {
        if (this.worldObj.isRemote) {
            return;
        }
        if (!this.isPouring) {
            return;
        }
        if (this.drained != null) {
            if (this.drained.amount <= 0) {
                this.drained = null;
                if (!this.stopPouring) {
                    this.doTransfer();
                } else {
                    this.reset();
                }
            } else {
                this.pour();
            }
        }
    }

    protected void doTransfer() {
        if (this.drained != null) {
            return;
        }
        TileEntity drainTE = this.worldObj.getTileEntity(this.pos.offset(this.direction));
        TileEntity fillTE = this.worldObj.getTileEntity(this.pos.down());
        if (drainTE instanceof IFluidHandler && fillTE instanceof IFluidHandler) {
            int filled;
            IFluidHandler toDrain = (IFluidHandler)drainTE;
            IFluidHandler toFill = (IFluidHandler)fillTE;
            FluidStack drained = toDrain.drain(this.direction, 144, false);
            if (drained != null && (filled = toFill.fill(EnumFacing.UP, drained, false)) > 0) {
                this.drained = toDrain.drain(this.direction, filled, true);
                this.isPouring = true;
                this.pour();
                if (!this.worldObj.isRemote && this.worldObj instanceof WorldServer) {
                    TinkerNetwork.sendToClients((WorldServer)this.worldObj, this.pos, (AbstractPacket)new FaucetActivationPacket(this.pos, drained));
                }
                return;
            }
        }
        this.reset();
    }

    protected void pour() {
        if (this.drained == null) {
            return;
        }
        TileEntity fillTE = this.worldObj.getTileEntity(this.pos.down());
        if (fillTE instanceof IFluidHandler) {
            IFluidHandler toFill = (IFluidHandler)fillTE;
            FluidStack fillStack = this.drained.copy();
            fillStack.amount = Math.min(this.drained.amount, 6);
            int filled = toFill.fill(EnumFacing.UP, fillStack, false);
            if (filled > 0) {
                this.drained.amount -= filled;
                fillStack.amount = filled;
                toFill.fill(EnumFacing.UP, fillStack, true);
            }
        } else {
            this.reset();
        }
    }

    protected void reset() {
        this.isPouring = false;
        this.stopPouring = false;
        this.drained = null;
        this.direction = EnumFacing.DOWN;
        this.lastRedstoneState = false;
        if (this.worldObj != null && !this.worldObj.isRemote && this.worldObj instanceof WorldServer) {
            TinkerNetwork.sendToClients((WorldServer)this.worldObj, this.pos, (AbstractPacket)new FaucetActivationPacket(this.pos, null));
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        if (this.drained != null) {
            this.drained.writeToNBT(compound);
            compound.setInteger("direction", this.direction.getIndex());
            compound.setBoolean("stop", this.stopPouring);
        }
    }

    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.drained = FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound);
        if (this.drained != null) {
            this.isPouring = true;
            this.direction = EnumFacing.values()[compound.getInteger("direction")];
            this.stopPouring = compound.getBoolean("stop");
        } else {
            this.reset();
        }
    }

    public void onActivationPacket(FluidStack fluid) {
        if (fluid == null) {
            this.reset();
        } else {
            this.drained = fluid;
            this.isPouring = true;
            this.direction = (EnumFacing)this.worldObj.getBlockState(this.pos).getValue((IProperty)BlockFaucet.FACING);
        }
    }

    public Packet getDescriptionPacket() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return new S35PacketUpdateTileEntity(this.getPos(), this.getBlockMetadata(), tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readFromNBT(pkt.getNbtCompound());
    }
}

