/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import slimeknights.tconstruct.smeltery.tileentity.TileFaucet;

public class FaucetRenderer
extends TileEntitySpecialRenderer<TileFaucet> {
    public void renderTileEntityAt(TileFaucet te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!te.isPouring || te.drained == null) {
            return;
        }
        float yMin = 0.0f;
        IBlockState state = te.getWorld().getBlockState(te.getPos().down());
        Block block = state.getBlock();
        if (block == TinkerSmeltery.searedTank) {
            yMin = -1.0f;
        } else if (block == TinkerSmeltery.castingBlock) {
            yMin = state.getValue(BlockCasting.TYPE) == BlockCasting.CastingType.TABLE ? -0.125f : -0.725f;
        }
        if (te.direction == EnumFacing.UP) {
            RenderUtil.renderFluidCuboid(te.drained, te.getPos(), x, y, z, 0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
            if (yMin < 0.0f) {
                RenderUtil.renderFluidCuboid(te.drained, te.getPos(), x, y, z, 0.375, -1.0, 0.375, 0.625, 0.0, 0.625);
            }
        }
        if (te.direction.getHorizontalIndex() >= 0) {
            float r = -90.0f * (float)(2 + te.direction.getHorizontalIndex());
            float o = 0.5f;
            RenderUtil.pre(x, y, z);
            Tessellator tessellator = Tessellator.getInstance();
            WorldRenderer renderer = tessellator.getWorldRenderer();
            renderer.begin(7, DefaultVertexFormats.BLOCK);
            Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationBlocksTexture);
            int color = te.drained.getFluid().getColor(te.drained);
            int brightness = te.getWorld().getCombinedLight(te.getPos(), te.drained.getFluid().getLuminosity());
            TextureAtlasSprite flowing = Minecraft.getMinecraft().getTextureMapBlocks().getTextureExtry(te.drained.getFluid().getFlowing(te.drained).toString());
            GlStateManager.translate((float)o, (float)0.0f, (float)o);
            GlStateManager.rotate((float)r, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translate((float)(-o), (float)0.0f, (float)(-o));
            double x1 = 0.375;
            double x2 = 0.625;
            double y1 = 0.375;
            double y2 = 0.625;
            double z1 = 0.0;
            double z2 = 0.375;
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, true);
            y1 = 0.0;
            z1 = 0.375;
            z2 = 0.5;
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
            RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.UP, color, brightness, true);
            if (yMin < 0.0f) {
                y1 = yMin;
                y2 = 0.0;
                RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.DOWN, color, brightness, true);
                RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.NORTH, color, brightness, true);
                RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.EAST, color, brightness, true);
                RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.SOUTH, color, brightness, true);
                RenderUtil.putTexturedQuad(renderer, flowing, x1, y1, z1, x2 - x1, y2 - y1, z2 - z1, EnumFacing.WEST, color, brightness, true);
            }
            tessellator.draw();
            RenderUtil.post();
        }
    }
}

