/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.smeltery.tileentity.TileSmelteryComponent;

public class BlockEnumSmeltery<T extends Enum<T> & IStringSerializable>
extends EnumBlock<T>
implements ITileEntityProvider {
    public BlockEnumSmeltery(PropertyEnum<T> prop, Class<T> clazz) {
        this(Material.rock, prop, clazz);
    }

    public BlockEnumSmeltery(Material material, PropertyEnum<T> prop, Class<T> clazz) {
        super(material, prop, clazz);
        this.setHardness(3.0f);
        this.setResistance(20.0f);
        this.setStepSound(soundTypeMetal);
        this.setCreativeTab((CreativeTabs)TinkerRegistry.tabSmeltery);
        this.isBlockContainer = true;
    }

    public TileEntity createNewTileEntity(World worldIn, int meta) {
        return new TileSmelteryComponent();
    }

    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.getTileEntity(pos);
        if (te instanceof TileSmelteryComponent) {
            ((TileSmelteryComponent)te).notifyMasterOfChange();
        }
        super.breakBlock(worldIn, pos, state);
        worldIn.removeTileEntity(pos);
    }

    public void onNeighborBlockChange(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity te = worldIn.getTileEntity(pos);
        if (te instanceof TileSmelteryComponent) {
            ((TileSmelteryComponent)te).notifyMasterOfChange();
        }
    }

    public boolean onBlockEventReceived(World worldIn, BlockPos pos, IBlockState state, int eventID, int eventParam) {
        super.onBlockEventReceived(worldIn, pos, state, eventID, eventParam);
        TileEntity tileentity = worldIn.getTileEntity(pos);
        return tileentity != null && tileentity.receiveClientEvent(eventID, eventParam);
    }
}

