/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.shared;

import com.google.common.eventbus.Subscribe;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.item.ItemEdible;
import slimeknights.mantle.item.ItemMetaDynamic;
import slimeknights.mantle.pulsar.pulse.Pulse;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerPulse;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.shared.AchievementEvents;
import slimeknights.tconstruct.shared.block.BlockFirewood;
import slimeknights.tconstruct.shared.block.BlockMetal;
import slimeknights.tconstruct.shared.block.BlockOre;
import slimeknights.tconstruct.shared.block.BlockSoil;
import slimeknights.tconstruct.shared.item.ItemMetaDynamicTinkers;
import slimeknights.tconstruct.shared.worldgen.NetherOreGenerator;

@Pulse(id="TinkerCommons", forced=true)
public class TinkerCommons
extends TinkerPulse {
    public static final String PulseId = "TinkerCommons";
    static final Logger log = Util.getLogger("TinkerCommons");
    @SidedProxy(clientSide="slimeknights.tconstruct.shared.CommonsClientProxy", serverSide="slimeknights.tconstruct.common.CommonProxy")
    public static CommonProxy proxy;
    public static BlockSoil blockSoil;
    public static BlockOre blockOre;
    public static BlockMetal blockMetal;
    public static Block blockFirewood;
    public static ItemStack grout;
    public static ItemStack slimyMudGreen;
    public static ItemStack slimyMudBlue;
    public static ItemStack slimyMudMagma;
    public static ItemStack graveyardSoil;
    public static ItemStack consecratedSoil;
    public static ItemStack mudBrickBlock;
    public static ItemStack oreCobalt;
    public static ItemStack oreArdite;
    public static ItemStack blockCobalt;
    public static ItemStack blockArdite;
    public static ItemStack blockManyullyn;
    public static ItemStack blockPigIron;
    public static ItemStack blockKnightSlime;
    public static ItemStack blockSilkyJewel;
    public static ItemStack blockAlubrass;
    public static ItemStack lavawood;
    public static ItemStack firewood;
    public static ItemMetaDynamic nuggets;
    public static ItemMetaDynamic ingots;
    public static ItemMetaDynamic materials;
    public static ItemEdible edibles;
    public static ItemStack nuggetCobalt;
    public static ItemStack nuggetArdite;
    public static ItemStack nuggetManyullyn;
    public static ItemStack nuggetPigIron;
    public static ItemStack nuggetKnightSlime;
    public static ItemStack nuggetAlubrass;
    public static ItemStack ingotCobalt;
    public static ItemStack ingotArdite;
    public static ItemStack ingotManyullyn;
    public static ItemStack ingotPigIron;
    public static ItemStack ingotKnightSlime;
    public static ItemStack ingotAlubrass;
    public static ItemStack searedBrick;
    public static ItemStack mudBrick;
    public static ItemStack matSlimeBallBlue;
    public static ItemStack matSlimeBallPurple;
    public static ItemStack matSlimeBallBlood;
    public static ItemStack matSlimeBallMagma;
    public static ItemStack matSlimeCrystalGreen;
    public static ItemStack matSlimeCrystalBlue;
    public static ItemStack matSlimeCrystalMagma;
    public static ItemStack matExpanderW;
    public static ItemStack matExpanderH;
    public static ItemStack matReinforcement;
    public static ItemStack matCreativeModifier;
    public static ItemStack matSilkyCloth;
    public static ItemStack matSilkyJewel;
    public static ItemStack matNecroticBone;
    public static ItemStack bacon;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        boolean forced = Config.forceRegisterAll;
        blockSoil = TinkerCommons.registerEnumBlock(new BlockSoil(), "soil");
        grout = new ItemStack((Block)blockSoil, 1, BlockSoil.SoilTypes.GROUT.getMeta());
        slimyMudGreen = new ItemStack((Block)blockSoil, 1, BlockSoil.SoilTypes.SLIMY_MUD_GREEN.getMeta());
        slimyMudBlue = new ItemStack((Block)blockSoil, 1, BlockSoil.SoilTypes.SLIMY_MUD_BLUE.getMeta());
        slimyMudMagma = new ItemStack((Block)blockSoil, 1, BlockSoil.SoilTypes.SLIMY_MUD_MAGMA.getMeta());
        graveyardSoil = new ItemStack((Block)blockSoil, 1, BlockSoil.SoilTypes.GRAVEYARD.getMeta());
        consecratedSoil = new ItemStack((Block)blockSoil, 1, BlockSoil.SoilTypes.CONSECRATED.getMeta());
        mudBrickBlock = new ItemStack((Block)blockSoil, 1, BlockSoil.SoilTypes.MUDBRICK.getMeta());
        blockOre = TinkerCommons.registerEnumBlock(new BlockOre(), "ore");
        oreCobalt = new ItemStack((Block)blockOre, 1, BlockOre.OreTypes.COBALT.getMeta());
        oreArdite = new ItemStack((Block)blockOre, 1, BlockOre.OreTypes.ARDITE.getMeta());
        blockFirewood = TinkerCommons.registerEnumBlock(new BlockFirewood(), "firewood");
        blockFirewood.setLightLevel(0.5f);
        blockFirewood.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
        lavawood = new ItemStack(blockFirewood, 1, BlockFirewood.FirewoodType.LAVAWOOD.getMeta());
        firewood = new ItemStack(blockFirewood, 1, BlockFirewood.FirewoodType.FIREWOOD.getMeta());
        nuggets = TinkerCommons.registerItem(new ItemMetaDynamicTinkers(), "nuggets");
        ingots = TinkerCommons.registerItem(new ItemMetaDynamicTinkers(), "ingots");
        materials = TinkerCommons.registerItem(new ItemMetaDynamic(), "materials");
        edibles = TinkerCommons.registerItem(new ItemEdible(), "edible");
        nuggets.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
        ingots.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
        materials.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
        edibles.setCreativeTab((CreativeTabs)TinkerRegistry.tabGeneral);
        matSlimeBallBlue = edibles.addFood(1, 1, 1.0f, "slimeball_blue", new PotionEffect[0]);
        matSlimeBallPurple = edibles.addFood(2, 1, 2.0f, "slimeball_purple", new PotionEffect[0]);
        matSlimeBallBlood = edibles.addFood(3, 1, 1.5f, "slimeball_blood", new PotionEffect[0]);
        matSlimeBallMagma = edibles.addFood(4, 2, 1.0f, "slimeball_magma", new PotionEffect[0]);
        if (TinkerCommons.isSmelteryLoaded() || forced) {
            searedBrick = materials.addMeta(0, "seared_brick");
            mudBrick = materials.addMeta(1, "mud_brick");
        }
        if (TinkerCommons.isToolsLoaded() || TinkerCommons.isSmelteryLoaded() || forced) {
            nuggetCobalt = nuggets.addMeta(0, "cobalt");
            ingotCobalt = ingots.addMeta(0, "cobalt");
            nuggetArdite = nuggets.addMeta(1, "ardite");
            ingotArdite = ingots.addMeta(1, "ardite");
            nuggetManyullyn = nuggets.addMeta(2, "manyullyn");
            ingotManyullyn = ingots.addMeta(2, "manyullyn");
            nuggetPigIron = nuggets.addMeta(4, "pigiron");
            ingotPigIron = ingots.addMeta(4, "pigiron");
            nuggetAlubrass = nuggets.addMeta(5, "alubrass");
            ingotAlubrass = ingots.addMeta(5, "alubrass");
            blockMetal = TinkerCommons.registerEnumBlock(new BlockMetal(), "metal");
            blockCobalt = new ItemStack((Block)blockMetal, 1, BlockMetal.MetalTypes.COBALT.getMeta());
            blockArdite = new ItemStack((Block)blockMetal, 1, BlockMetal.MetalTypes.ARDITE.getMeta());
            blockManyullyn = new ItemStack((Block)blockMetal, 1, BlockMetal.MetalTypes.MANYULLYN.getMeta());
            blockKnightSlime = new ItemStack((Block)blockMetal, 1, BlockMetal.MetalTypes.KNIGHTSLIME.getMeta());
            blockPigIron = new ItemStack((Block)blockMetal, 1, BlockMetal.MetalTypes.PIGIRON.getMeta());
            blockAlubrass = new ItemStack((Block)blockMetal, 1, BlockMetal.MetalTypes.ALUBRASS.getMeta());
            blockSilkyJewel = new ItemStack((Block)blockMetal, 1, BlockMetal.MetalTypes.SILKY_JEWEL.getMeta());
        }
        if (TinkerCommons.isToolsLoaded() || forced) {
            bacon = edibles.addFood(0, 4, 0.6f, "bacon", new PotionEffect[0]);
            matSlimeCrystalGreen = materials.addMeta(9, "slimecrystal_green");
            matSlimeCrystalBlue = materials.addMeta(10, "slimecrystal_blue");
            matSlimeCrystalMagma = materials.addMeta(11, "slimecrystal_magma");
            matExpanderW = materials.addMeta(12, "expander_w");
            matExpanderH = materials.addMeta(13, "expander_h");
            matReinforcement = materials.addMeta(14, "reinforcement");
            matSilkyCloth = materials.addMeta(15, "silky_cloth");
            matSilkyJewel = materials.addMeta(16, "silky_jewel");
            matNecroticBone = materials.addMeta(17, "necrotic_bone");
            matCreativeModifier = materials.addMeta(50, "creative_modifier");
            ingotKnightSlime = ingots.addMeta(3, "knightslime");
            nuggetKnightSlime = nuggets.addMeta(3, "knightslime");
        }
        this.registerRecipies();
        proxy.preInit();
        TinkerRegistry.tabGeneral.setDisplayIcon(matSlimeBallBlue);
    }

    private void registerRecipies() {
        GameRegistry.addSmelting((ItemStack)graveyardSoil, (ItemStack)consecratedSoil, (float)0.0f);
        GameRegistry.addShapelessRecipe((ItemStack)graveyardSoil, (Object[])new Object[]{Blocks.dirt, Items.rotten_flesh, new ItemStack(Items.dye, 1, 15)});
        if (mudBrick != null) {
            GameRegistry.addShapedRecipe((ItemStack)mudBrickBlock, (Object[])new Object[]{"BB", "BB", Character.valueOf('B'), mudBrick});
        }
        GameRegistry.addShapelessRecipe((ItemStack)firewood, (Object[])new Object[]{Items.blaze_powder, lavawood, Items.blaze_powder});
        TinkerCommons.registerMetalRecipes("Cobalt", ingotCobalt, nuggetCobalt, blockCobalt);
        TinkerCommons.registerMetalRecipes("Ardite", ingotArdite, nuggetArdite, blockArdite);
        TinkerCommons.registerMetalRecipes("Manyullyn", ingotManyullyn, nuggetManyullyn, blockManyullyn);
        TinkerCommons.registerMetalRecipes("Knightslime", ingotKnightSlime, nuggetKnightSlime, blockKnightSlime);
        TinkerCommons.registerMetalRecipes("Pigiron", ingotPigIron, nuggetPigIron, blockPigIron);
        TinkerCommons.registerMetalRecipes("Alubrass", ingotAlubrass, nuggetAlubrass, blockAlubrass);
        if (blockSilkyJewel != null && matSilkyJewel != null) {
            GameRegistry.addShapedRecipe((ItemStack)blockSilkyJewel, (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), matSilkyJewel});
        }
    }

    private static void registerMetalRecipes(String oreString, ItemStack ingot, ItemStack nugget, ItemStack block) {
        if (ingot == null) {
            return;
        }
        if (nugget != null) {
            TinkerCommons.registerFullrecipe(nugget, ingot, "nugget" + oreString, "ingot" + oreString);
        }
        if (block != null) {
            TinkerCommons.registerFullrecipe(ingot, block, "ingot" + oreString, "block" + oreString);
        }
    }

    private static void registerFullrecipe(ItemStack small, ItemStack big, String oreSmall, String oreBig) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(big, new Object[]{"###", "###", "###", Character.valueOf('#'), oreSmall}));
        small = small.copy();
        small.stackSize = 9;
        GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(small, new Object[]{oreBig}));
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)NetherOreGenerator.INSTANCE, (int)0);
        MinecraftForge.EVENT_BUS.register((Object)new AchievementEvents());
    }
}

