/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.tools.TinkerTools;

public class MaterialIntegration {
    public Material material;
    public Fluid fluid;
    public String oreSuffix;
    public String oreRequirement;
    private boolean integrated;
    private boolean toolforge = false;

    public MaterialIntegration(Material material) {
        this(material, null);
    }

    public MaterialIntegration(Material material, Fluid fluid) {
        this(null, material, fluid, null);
    }

    public MaterialIntegration(Material material, Fluid fluid, String oreSuffix) {
        this("ingot" + oreSuffix, material, fluid, oreSuffix);
    }

    public MaterialIntegration(String oreRequirement, Material material, Fluid fluid, String oreSuffix) {
        this.material = material;
        this.fluid = fluid;
        this.oreSuffix = oreSuffix;
        this.oreRequirement = oreRequirement;
        this.integrated = false;
    }

    public MaterialIntegration toolforge() {
        this.toolforge = true;
        return this;
    }

    public void integrate() {
        if (this.integrated) {
            return;
        }
        if (this.oreRequirement != null && !Config.forceRegisterAll) {
            boolean found = false;
            for (String ore : OreDictionary.getOreNames()) {
                if (!ore.equals(this.oreRequirement)) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        this.integrated = true;
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            this.fluid = null;
        }
        if (this.fluid != null && !FluidRegistry.isFluidRegistered((Fluid)this.fluid)) {
            TinkerFluids.registerFluid(this.fluid);
            this.registerFluidBlock();
            FluidRegistry.addBucketForFluid((Fluid)this.fluid);
        }
        if (this.material != null) {
            TinkerRegistry.addMaterial(this.material);
            if (this.fluid != null) {
                this.material.setFluid(this.fluid);
                this.material.setCastable(true);
            } else {
                this.material.setCraftable(true);
            }
        }
        if (this.toolforge && this.oreSuffix != null && !this.oreSuffix.isEmpty()) {
            TinkerTools.registerToolForgeBlock("block" + this.oreSuffix);
        }
    }

    public void integrateRecipes() {
        if (!this.integrated) {
            return;
        }
        if (this.fluid != null && this.oreSuffix != null) {
            TinkerSmeltery.registerOredictMeltingCasting(this.fluid, this.oreSuffix);
        }
        if (this.material != null) {
            TinkerSmeltery.registerToolpartMeltingCasting(this.material);
        }
    }

    public void registerFluidBlock() {
        TinkerFluids.registerMoltenBlock(this.fluid);
        TinkerFluids.proxy.registerFluidModels(this.fluid);
    }
}

