/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.registry.GameData;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.CommonProxy;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.CustomFontRenderer;
import slimeknights.tconstruct.library.client.CustomTextureCreator;
import slimeknights.tconstruct.library.client.ItemBlockModelSetter;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.model.ModifierModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModelLoader;
import slimeknights.tconstruct.library.client.particle.EntitySlimeFx;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.shared.TinkerCommons;

public abstract class ClientProxy
extends CommonProxy {
    public static CustomFontRenderer fontRenderer;
    protected static final ToolModelLoader loader;
    protected static final MaterialModelLoader materialLoader;
    protected static final ModifierModelLoader modifierLoader;

    public static void initClient() {
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)loader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)materialLoader);
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)modifierLoader);
        MinecraftForge.EVENT_BUS.register((Object)new ItemBlockModelSetter());
    }

    public static void initRenderer() {
        CustomTextureCreator creator = new CustomTextureCreator();
        MinecraftForge.EVENT_BUS.register((Object)creator);
        ((IReloadableResourceManager)Minecraft.getMinecraft().getResourceManager()).registerReloadListener((IResourceManagerReloadListener)creator);
        fontRenderer = new CustomFontRenderer(Minecraft.getMinecraft().gameSettings, new ResourceLocation("textures/font/ascii.png"), Minecraft.getMinecraft().renderEngine);
        if (Minecraft.getMinecraft().gameSettings.language != null) {
            fontRenderer.setUnicodeFlag(Minecraft.getMinecraft().getLanguageManager().isCurrentLocaleUnicode() || Minecraft.getMinecraft().gameSettings.forceUnicodeFont);
            fontRenderer.setBidiFlag(Minecraft.getMinecraft().getLanguageManager().isCurrentLanguageBidirectional());
        }
        ((IReloadableResourceManager)Minecraft.getMinecraft().getResourceManager()).registerReloadListener((IResourceManagerReloadListener)fontRenderer);
        try {
            Class<?> clazz = Class.forName("codechicken.lib.gui.GuiDraw");
            Field field = clazz.getDeclaredField("fontRenderer");
            field.set(null, (Object)fontRenderer);
        }
        catch (ClassNotFoundException e) {
            TConstruct.log.debug("Could not integrate FondRenderer with NEI");
        }
        catch (NoSuchFieldException e) {
            TConstruct.log.debug("Could not integrate FondRenderer with NEI");
        }
        catch (IllegalAccessException e) {
            TConstruct.log.debug("Could not integrate FondRenderer with NEI");
        }
    }

    protected ResourceLocation registerModel(Item item, String ... customVariants) {
        return this.registerModel(item, 0, customVariants);
    }

    protected ResourceLocation registerModel(Item item, int meta, String ... customVariants) {
        ResourceLocation o = GameData.getItemRegistry().getNameForObject((Object)item);
        if (o == null) {
            TConstruct.log.error("Trying to register a model for an unregistered item: %s" + item.getUnlocalizedName());
            return null;
        }
        ResourceLocation location = o;
        location = new ResourceLocation(location.getResourceDomain(), location.getResourcePath());
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(location, "inventory"));
        if (customVariants.length > 0) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        }
        for (String customVariant : customVariants) {
            String custom = location.getResourceDomain() + ":" + customVariant;
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(custom)});
        }
        return location;
    }

    protected void registerItemModel(ItemStack item, String name) {
        if (!name.contains(":")) {
            name = Util.resource(name);
        }
        ModelLoader.registerItemVariants((Item)item.getItem(), (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(name)});
        ModelLoader.setCustomModelResourceLocation((Item)item.getItem(), (int)item.getMetadata(), (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    protected ResourceLocation registerToolModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        String path = "tools/" + itemLocation.getResourcePath() + ToolModelLoader.EXTENSION;
        return this.registerToolModel(item, new ResourceLocation(itemLocation.getResourceDomain(), path));
    }

    protected ResourceLocation registerToolModel(Item item, ResourceLocation location) {
        if (!location.getResourcePath().endsWith(ToolModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + ToolModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ClientProxy.registerIt(item, location);
    }

    public ResourceLocation registerMaterialItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return this.registerMaterialModel(item, new ResourceLocation(itemLocation.getResourceDomain(), itemLocation.getResourcePath() + MaterialModelLoader.EXTENSION));
    }

    public ResourceLocation registerMaterialModel(Item item, ResourceLocation location) {
        if (!location.getResourcePath().endsWith(MaterialModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + MaterialModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ClientProxy.registerIt(item, location);
    }

    public void registerModifierModel(IModifier modifier, ResourceLocation location) {
        modifierLoader.registerModifierFile(modifier.getIdentifier(), location);
    }

    public ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = ClientProxy.getItemLocation(item);
        if (itemLocation == null) {
            return null;
        }
        return ClientProxy.registerIt(item, itemLocation);
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation getModelLocation(ItemStack stack) {
                return new ModelResourceLocation(location, "inventory");
            }
        });
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    public static ResourceLocation getItemLocation(Item item) {
        return Util.getItemLocation(item);
    }

    @Override
    public void sendPacketToServerOnly(AbstractPacket packet) {
        TinkerNetwork.sendToServer(packet);
    }

    @Override
    public void spawnSlimeParticle(World world, double x, double y, double z) {
        Minecraft.getMinecraft().effectRenderer.addEffect((EntityFX)new EntitySlimeFx(world, x, y, z, TinkerCommons.matSlimeBallBlue.getItem(), TinkerCommons.matSlimeBallBlue.getItemDamage()));
    }

    @Override
    public void preventPlayerSlowdown(Entity player, float originalSpeed, Item item) {
        if (player instanceof EntityPlayerSP) {
            EntityPlayerSP playerSP = (EntityPlayerSP)player;
            ItemStack usingItem = playerSP.inventory.getCurrentItem();
            if (usingItem != null && usingItem.getItem() == item) {
                playerSP.movementInput.moveForward *= originalSpeed * 5.0f;
                playerSP.movementInput.moveStrafe *= originalSpeed * 5.0f;
            }
        }
    }

    static {
        loader = new ToolModelLoader();
        materialLoader = new MaterialModelLoader();
        modifierLoader = new ModifierModelLoader();
    }

    public static class PatternMeshDefinition
    implements ItemMeshDefinition {
        private final ResourceLocation baseLocation;

        public PatternMeshDefinition(ResourceLocation baseLocation) {
            this.baseLocation = baseLocation;
        }

        public ModelResourceLocation getModelLocation(ItemStack stack) {
            Item item = Pattern.getPartFromTag(stack);
            String suffix = "";
            if (item != null) {
                suffix = Pattern.getTextureIdentifier(item);
            }
            return new ModelResourceLocation(new ResourceLocation(this.baseLocation.getResourceDomain(), this.baseLocation.getResourcePath() + suffix), "inventory");
        }
    }
}

