/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderHell;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlime;
import slimeknights.tconstruct.world.block.BlockSlimeDirt;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.worldgen.SlimeIslandGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeLakeGenerator;
import slimeknights.tconstruct.world.worldgen.SlimePlantGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeTreeGenerator;

public class MagmaSlimeIslandGenerator
extends SlimeIslandGenerator {
    public static MagmaSlimeIslandGenerator INSTANCE = new MagmaSlimeIslandGenerator();
    protected SlimeLakeGenerator lakeGenMagma;
    protected SlimePlantGenerator plantGenMagma;
    protected SlimeTreeGenerator treeGenMagma;
    protected IBlockState dirtMagma;
    protected IBlockState grassMagma;

    public MagmaSlimeIslandGenerator() {
        this.air = Blocks.lava.getDefaultState();
        IBlockState slimeMagma = TinkerWorld.slimeBlockCongealed.getDefaultState().withProperty(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.MAGMA));
        IBlockState slimeBlood = TinkerWorld.slimeBlockCongealed.getDefaultState().withProperty(BlockSlime.TYPE, (Comparable)((Object)BlockSlime.SlimeType.BLOOD));
        this.dirtMagma = TinkerWorld.slimeDirt.getDefaultState().withProperty(BlockSlimeDirt.TYPE, (Comparable)((Object)BlockSlimeDirt.DirtType.MAGMA));
        this.grassMagma = TinkerWorld.slimeGrass.getStateFromDirt(this.dirtMagma).withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.ORANGE));
        this.lakeGenMagma = new SlimeLakeGenerator(Blocks.lava.getDefaultState(), slimeMagma, slimeMagma, slimeMagma, slimeMagma, slimeMagma, slimeBlood);
        this.treeGenMagma = new SlimeTreeGenerator(5, 4, slimeMagma, TinkerWorld.slimeLeaves.getDefaultState().withProperty(BlockSlimeGrass.FOLIAGE, (Comparable)((Object)BlockSlimeGrass.FoliageType.ORANGE)), null);
        this.plantGenMagma = new SlimePlantGenerator(BlockSlimeGrass.FoliageType.ORANGE, false);
    }

    @Override
    protected String getDataName() {
        return "MagmaIslands";
    }

    @Override
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int z;
        if (!Config.genSlimeIslands) {
            return;
        }
        if (world.getWorldType() == WorldType.FLAT && !Config.genIslandsInSuperflat) {
            return;
        }
        if (!(chunkGenerator instanceof ChunkProviderHell)) {
            return;
        }
        if (random.nextInt(Config.magmaIslandsRate) > 0) {
            return;
        }
        int y = 31;
        int x = chunkX * 16 + 7 + random.nextInt(6) - 3;
        BlockPos pos = new BlockPos(x, y, z = chunkZ * 16 + 7 + random.nextInt(6) - 3);
        if (this.isLava(world, pos) && this.isLava(world, pos.north()) && this.isLava(world, pos.east()) && this.isLava(world, pos.south()) && this.isLava(world, pos.west())) {
            this.generateIsland(random, world, x, z, y + 1, this.dirtMagma, this.grassMagma, null, this.lakeGenMagma, this.treeGenMagma, this.plantGenMagma);
        }
    }

    private boolean isLava(World world, BlockPos pos) {
        return world.getBlockState(pos).getBlock() == Blocks.lava;
    }
}

