/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.item.BroadSword;

public class Cleaver
extends BroadSword {
    public Cleaver() {
        super(PartMaterialType.handle(TinkerTools.toughToolRod), PartMaterialType.head(TinkerTools.largeSwordBlade), PartMaterialType.head(TinkerTools.largePlate), PartMaterialType.extra(TinkerTools.toughToolRod));
    }

    @Override
    public ItemStack onItemRightClick(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn) {
        return itemStackIn;
    }

    @Override
    public float damagePotential() {
        return 0.9f;
    }

    @Override
    public boolean hitEntity(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        target.hurtResistantTime += 12;
        target.hurtTime += 12;
        return super.hitEntity(stack, target, attacker);
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entity, int itemSlot, boolean isSelected) {
        EntityPlayer player;
        ItemStack equipped;
        super.onUpdate(stack, worldIn, entity, itemSlot, isSelected);
        if (entity instanceof EntityPlayer && (equipped = (player = (EntityPlayer)entity).getCurrentEquippedItem()) == stack) {
            player.addPotionEffect(new PotionEffect(Potion.digSlowdown.id, 2, 2, true, false));
        }
    }

    @Override
    public int[] getRepairParts() {
        return new int[]{1, 2};
    }

    @Override
    public NBTTagCompound buildTag(List<Material> materials) {
        HandleMaterialStats handle = (HandleMaterialStats)materials.get(0).getStatsOrUnknown("handle");
        HeadMaterialStats head = (HeadMaterialStats)materials.get(1).getStatsOrUnknown("head");
        HeadMaterialStats shield = (HeadMaterialStats)materials.get(2).getStatsOrUnknown("head");
        ExtraMaterialStats guard = (ExtraMaterialStats)materials.get(3).getStatsOrUnknown("extra");
        ToolNBT data = new ToolNBT();
        data.head(head, shield);
        data.extra(guard);
        data.handle(handle);
        data.attack *= 1.4f;
        data.attack += 2.0f;
        data.durability = (int)((float)data.durability * 2.0f);
        data.modifiers = 2;
        return data.get();
    }
}

