/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client.module;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.client.gui.GuiWidgetTabs;
import slimeknights.tconstruct.tools.client.GuiTinkerStation;

public class GuiTinkerTabs
extends GuiModule {
    protected static final GuiElement GUI_Tab = new GuiElement(0, 2, 28, 28, 256, 256);
    protected static final GuiElement GUI_TabActiveL = new GuiElement(0, 32, 28, 32, 256, 256);
    protected static final GuiElement GUI_TabActiveC = new GuiElement(28, 32, 28, 32, 256, 256);
    protected static final GuiElement GUI_TabActiveR = new GuiElement(140, 32, 28, 32, 256, 256);
    public GuiWidgetTabs tabs;
    public List<BlockPos> tabData;
    public final GuiTinkerStation parent;

    public GuiTinkerTabs(GuiTinkerStation parent, Container container) {
        super((GuiMultiModule)parent, container, false, false);
        this.parent = parent;
        this.xSize = GuiTinkerTabs.GUI_TabActiveC.w;
        this.ySize = GuiTinkerTabs.GUI_TabActiveC.h;
        this.tabs = new GuiWidgetTabs((GuiMultiModule)parent, GUI_Tab, GUI_Tab, GUI_Tab, GUI_TabActiveL, GUI_TabActiveC, GUI_TabActiveR);
        this.tabData = Lists.newArrayList();
    }

    public void addTab(ItemStack icon, BlockPos data) {
        this.tabData.add(data);
        this.tabs.addTab(icon);
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        this.guiLeft = parentX;
        this.guiTop = parentY - this.ySize;
        this.tabs.setPosition(this.guiLeft + 4, this.guiTop);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int sel = this.tabs.selected;
        this.tabs.update(mouseX, mouseY);
        this.tabs.draw();
        if (sel != this.tabs.selected) {
            this.parent.onTabSelection(this.tabs.selected);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        if (this.tabs.highlighted > -1) {
            BlockPos pos = this.tabData.get(this.tabs.highlighted);
            IBlockState state = Minecraft.getMinecraft().thePlayer.worldObj.getBlockState(pos);
            ItemStack stack = new ItemStack(state.getBlock(), 1, state.getBlock().getMetaFromState(state));
            String name = stack.getDisplayName();
            this.drawHoveringText(Lists.newArrayList((Object[])new String[]{name}), mouseX - this.guiLeft, mouseY - this.guiTop);
        }
    }
}

