/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.client;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.smeltery.SmelteryTank;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;

public class SmelteryRenderer
extends TileEntitySpecialRenderer<TileSmeltery> {
    public void renderTileEntityAt(TileSmeltery smeltery, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!smeltery.isActive()) {
            return;
        }
        SmelteryTank tank = smeltery.getTank();
        if (tank == null || smeltery.minPos == null || smeltery.maxPos == null) {
            return;
        }
        List<FluidStack> fluids = tank.getFluids();
        double x1 = smeltery.minPos.getX() - smeltery.getPos().getX();
        double y1 = smeltery.minPos.getY() - smeltery.getPos().getY();
        double z1 = smeltery.minPos.getZ() - smeltery.getPos().getZ();
        double x2 = smeltery.maxPos.getX() - smeltery.getPos().getX();
        double z2 = smeltery.maxPos.getZ() - smeltery.getPos().getZ();
        if (!fluids.isEmpty()) {
            BlockPos minPos = new BlockPos(x1, y1, z1);
            BlockPos maxPos = new BlockPos(x2, y1, z2);
            int yd = 1 + Math.max(0, smeltery.maxPos.getY() - smeltery.minPos.getY());
            int[] heights = SmelteryRenderer.calcLiquidHeights(fluids, tank.getMaxCapacity(), yd * 1000 - (int)((double)RenderUtil.FLUID_OFFSET * 2000.0), 100);
            double curY = RenderUtil.FLUID_OFFSET;
            for (int i = 0; i < fluids.size(); ++i) {
                double h = (double)heights[i] / 1000.0;
                RenderUtil.renderStackedFluidCuboid(fluids.get(i), x, y, z, smeltery.minPos, minPos, maxPos, curY, curY + h);
                curY += h;
            }
        }
        int xd = 1 + smeltery.maxPos.getX() - smeltery.minPos.getX();
        int zd = 1 + smeltery.maxPos.getZ() - smeltery.minPos.getZ();
        int layer = xd * zd;
        Minecraft.getMinecraft().renderEngine.bindTexture(TextureMap.locationBlocksTexture);
        RenderUtil.pre(x, y, z);
        GlStateManager.disableCull();
        GlStateManager.translate((double)x1, (double)y1, (double)z1);
        GlStateManager.translate((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.enableStandardItemLighting();
        for (int i = 0; i < smeltery.getSizeInventory(); ++i) {
            if (!smeltery.isStackInSlot(i)) continue;
            int h = i / layer;
            int i2 = i % layer;
            BlockPos pos = smeltery.minPos.add(i2 % xd, h, i2 / xd);
            int brightness = smeltery.getWorld().getCombinedLight(pos, 0);
            ItemStack stack = smeltery.getStackInSlot(i);
            boolean isItem = !(stack.getItem() instanceof ItemBlock);
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)(brightness % 65536) / 1.0f), (float)((float)(brightness / 65536) / 1.0f));
            GlStateManager.translate((float)(i2 % xd), (float)h, (float)(i2 / xd));
            GlStateManager.scale((float)2.0f, (float)2.0f, (float)2.0f);
            if (isItem) {
                GlStateManager.rotate((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            IBakedModel model = Minecraft.getMinecraft().getRenderItem().getItemModelMesher().getItemModel(stack);
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.NONE);
            Minecraft.getMinecraft().getRenderItem().renderItem(stack, model);
            if (isItem) {
                GlStateManager.rotate((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.scale((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translate((float)(-i2 % xd), (float)(-h), (float)(-i2 / xd));
        }
        RenderHelper.enableStandardItemLighting();
        RenderUtil.post();
    }

    public static int[] calcLiquidHeights(List<FluidStack> liquids, int capacity, int height, int min) {
        int[] fluidHeights = new int[liquids.size()];
        if (liquids.size() > 0) {
            for (int i = 0; i < liquids.size(); ++i) {
                FluidStack liquid = liquids.get(i);
                float h = (float)liquid.amount / (float)capacity;
                fluidHeights[i] = Math.max(min, (int)Math.ceil(h * (float)height));
            }
            int sum = 0;
            do {
                sum = 0;
                int biggest = -1;
                int m = 0;
                for (int i = 0; i < fluidHeights.length; ++i) {
                    sum += fluidHeights[i];
                    if (liquids.get((int)i).amount <= biggest) continue;
                    biggest = liquids.get((int)i).amount;
                    m = i;
                }
                if (fluidHeights[m] == 0) break;
                if (sum <= height) continue;
                int n = m;
                fluidHeights[n] = fluidHeights[n] - 1;
            } while (sum > height);
        }
        return fluidHeights;
    }
}

