package slimeknights.tconstruct.tools.client;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.inventory.BaseContainer;

public class GuiScalingChest extends GuiDynInventory {

  protected final IInventory inventory;

  public GuiScalingChest(GuiMultiModule parent, BaseContainer container) {
    super(parent, container);

    inventory = (IInventory)container.getTile();
    slotCount = inventory.func_70302_i_();
    sliderActive = true;
  }

  @Override
  public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
    this.field_147003_i = parentX + xOffset;
    this.field_147009_r = parentY + yOffset;

    // calculate rows and columns from space
    columns = (field_146999_f - slider.width) / slot.w;
    rows = field_147000_g / slot.h;

    updateSlider();
    updateSlots();
  }

  @Override
  protected void updateSlider() {
    sliderActive = slotCount > columns * rows;
    super.updateSlider();
    slider.setEnabled(sliderActive);
    slider.show();
  }

  @Override
  public void update(int mouseX, int mouseY) {
    slotCount = inventory.func_70302_i_();
    super.update(mouseX, mouseY);

    updateSlider();
    slider.show();
    updateSlots();
  }

  @Override
  public boolean shouldDrawSlot(Slot slot) {
    if(slot.getSlotIndex() >= inventory.func_70302_i_()) {
      return false;
    }
    return super.shouldDrawSlot(slot);
  }
}
