package slimeknights.tconstruct.shared.tileentity;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import slimeknights.mantle.tileentity.TileInventory;
import slimeknights.tconstruct.common.config.Config;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.client.model.ModelHelper;
import slimeknights.tconstruct.shared.block.BlockTable;
import slimeknights.tconstruct.shared.block.PropertyTableItem;
import slimeknights.tconstruct.tools.network.InventorySlotSyncPacket;

public class TileTable extends TileInventory {

  public static final String FEET_TAG = "textureBlock";
  public static final String FACE_TAG = "facing";
  protected int displaySlot = 0;

  // default constructor for loading
  public TileTable() {
    super("", 0, 0);
  }

  public TileTable(String name, int inventorySize) {
    super(name, inventorySize);
  }

  public TileTable(String name, int inventorySize, int maxStackSize) {
    super(name, inventorySize, maxStackSize);
  }

  public IExtendedBlockState writeExtendedBlockState(IExtendedBlockState state) {
    String texture = getTileData().func_74779_i("texture");

    // texture not loaded
    if(texture == null || texture.isEmpty()) {
      // load it from saved block
      ItemStack stack = ItemStack.func_77949_a(getTileData().func_74775_l(FEET_TAG));
      if(stack != null) {
        Block block = Block.func_149634_a(stack.func_77973_b());
        texture = ModelHelper.getTextureFromBlock(block, stack.func_77952_i()).func_94215_i();
        getTileData().func_74778_a("texture", texture);
      }
    }

    if(texture != null && !texture.isEmpty()) {
      state = state.withProperty(BlockTable.TEXTURE, texture);
    }

    EnumFacing facing = getFacing();
    state = state.withProperty((IUnlistedProperty<EnumFacing>)BlockTable.FACING, facing);

    state = setInventoryDisplay(state);

    return state;
  }

  protected IExtendedBlockState setInventoryDisplay(IExtendedBlockState state) {
    PropertyTableItem.TableItems toDisplay = new PropertyTableItem.TableItems();
    if(func_70301_a(displaySlot) != null) {
      ItemStack stack = func_70301_a(displaySlot);
      PropertyTableItem.TableItem item = getTableItem(stack);
      if(item != null) {
        toDisplay.items.add(item);
      }
    }
    // add inventory if needed
    return state.withProperty(BlockTable.INVENTORY, toDisplay);
  }

  @SideOnly(Side.CLIENT)
  public static PropertyTableItem.TableItem getTableItem(ItemStack stack) {
    if(stack == null)
      return null;
    IFlexibleBakedModel stackModel;
    IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
    if(model == null) {
      return null;
    }
    else if(model instanceof IFlexibleBakedModel) {
      stackModel = (IFlexibleBakedModel) model;
    }
    else {
      stackModel = new IFlexibleBakedModel.Wrapper(model, DefaultVertexFormats.field_176599_b);
    }

    PropertyTableItem.TableItem item = new PropertyTableItem.TableItem(stackModel, 0,-0.46875f,0, 0.8f, (float) (-Math.PI/2));
    if(stack.func_77973_b() instanceof  ItemBlock) {
      item.y = -0.3125f;
      item.s = 0.375f;
      item.r = 0;
    }
    return item;
  }

  @Override
  public Packet func_145844_m() {
    // note that this sends all of the tile data. you should change this if you use additional tile data
    NBTTagCompound tag = (NBTTagCompound) getTileData().func_74737_b();
    func_145841_b(tag);
    return new S35PacketUpdateTileEntity(this.func_174877_v(), this.func_145832_p(), tag);
  }

  @Override
  public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
    NBTTagCompound tag = pkt.func_148857_g();
    NBTBase feet = tag.func_74781_a(FEET_TAG);
    if(feet != null) {
      getTileData().func_74782_a(FEET_TAG, feet);
    }
    NBTBase facing = tag.func_74781_a(FACE_TAG);
    if(facing != null) {
      getTileData().func_74782_a(FACE_TAG, facing);
    }
    func_145839_a(tag);
  }

  public void setFacing(EnumFacing face) {
    getTileData().func_74768_a(FACE_TAG, face.func_176745_a());
  }

  public EnumFacing getFacing() {
    return EnumFacing.func_82600_a(getTileData().func_74762_e(FACE_TAG));
  }

  public void updateTextureBlock(NBTTagCompound tag) {
    getTileData().func_74782_a(FEET_TAG, tag);
  }

  public NBTTagCompound getTextureBlock() {
    return getTileData().func_74775_l(FEET_TAG);
  }

  @Override
  public void func_70299_a(int slot, ItemStack itemstack) {
    // we sync slot changes to all clients around
    if(this.field_145850_b != null  && this.field_145850_b instanceof WorldServer && !this.field_145850_b.field_72995_K && !ItemStack.func_77989_b(itemstack, func_70301_a(slot))) {
      TinkerNetwork.sendToClients((WorldServer) this.field_145850_b, this.field_174879_c, new InventorySlotSyncPacket(itemstack, slot, field_174879_c));
    }
    super.func_70299_a(slot, itemstack);

    if(func_145831_w() != null && func_145831_w().field_72995_K && Config.renderTableItems) {
      Minecraft.func_71410_x().field_71438_f.func_174960_a(field_174879_c);
    }
  }
}
