package slimeknights.tconstruct.library;

import com.google.common.collect.Maps;

import net.minecraft.item.Item;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.apache.logging.log4j.Logger;

import java.util.Map;

import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;

@SideOnly(Side.CLIENT)
public final class TinkerRegistryClient {

  // the logger for the library
  public static final Logger log = Util.getLogger("API-Client");

  private TinkerRegistryClient() {}

  /*---------------------------------------------------------------------------
  | GUI & CRAFTING                                                            |
  ---------------------------------------------------------------------------*/
  private static final Map<Item, ToolBuildGuiInfo> toolBuildInfo = Maps.newLinkedHashMap();

  public static void addToolBuilding(ToolBuildGuiInfo info) {
    toolBuildInfo.put(info.tool.func_77973_b(), info);
  }

  public static ToolBuildGuiInfo getToolBuildInfoForTool(Item tool) {
    return toolBuildInfo.get(tool);
  }

  public static void clear() {
    toolBuildInfo.clear();
  }
}
