/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.block.BlockSoil;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.entity.EntityBlueSlime;
import slimeknights.tconstruct.world.worldgen.MagmaSlimeIslandGenerator;
import slimeknights.tconstruct.world.worldgen.SlimeIslandGenerator;

public class WorldEvents {
    BiomeGenBase.SpawnListEntry magmaSlimeSpawn = new BiomeGenBase.SpawnListEntry(EntityMagmaCube.class, 250, 4, 6);
    BiomeGenBase.SpawnListEntry blueSlimeSpawn = new BiomeGenBase.SpawnListEntry(EntityBlueSlime.class, 20, 2, 4);

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        IBlockState state;
        Block block;
        if (event.entity == null) {
            return;
        }
        BlockPos pos = new BlockPos(event.entity.posX, event.entity.posY, event.entity.posZ);
        if (event.entity.worldObj.isAirBlock(pos)) {
            pos = pos.down();
        }
        if ((block = (state = event.entity.worldObj.getBlockState(pos)).getBlock()) == TinkerWorld.slimeBlockCongealed) {
            this.bounce(event.entity, 0.25f);
        } else if (block == TinkerCommons.blockSoil) {
            if (state.getValue(BlockSoil.TYPE) == BlockSoil.SoilTypes.SLIMY_MUD_GREEN || state.getValue(BlockSoil.TYPE) == BlockSoil.SoilTypes.SLIMY_MUD_BLUE) {
                this.bounce(event.entity, 0.15f);
            }
        } else if (block == TinkerWorld.slimeDirt || block == TinkerWorld.slimeGrass) {
            this.bounce(event.entity, 0.06f);
        }
    }

    private void bounce(Entity entity, float amount) {
        entity.motionY += (double)amount;
        entity.playSound("mob.slime.small", 0.5f + amount, 1.0f);
    }

    @SubscribeEvent
    public void extraSlimeSpawn(WorldEvent.PotentialSpawns event) {
        if (event.type == EnumCreatureType.MONSTER || event.type == EnumCreatureType.WATER_CREATURE) {
            if (MagmaSlimeIslandGenerator.INSTANCE.isSlimeIslandAt(event.world, event.pos.down(3))) {
                event.list.clear();
                event.list.add(this.magmaSlimeSpawn);
            }
            if (SlimeIslandGenerator.INSTANCE.isSlimeIslandAt(event.world, event.pos.down(3))) {
                event.list.clear();
                event.list.add(this.blueSlimeSpawn);
            }
        }
    }
}

