package slimeknights.tconstruct.world.worldgen;

import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

import java.util.Random;

import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.BlockSlimeGrass;
import slimeknights.tconstruct.world.block.BlockTallSlimeGrass;

public class SlimePlantGenerator implements IWorldGenerator {

  public final BlockSlimeGrass.FoliageType foliageType;
  public final boolean clumped;

  public SlimePlantGenerator(BlockSlimeGrass.FoliageType foliageType, boolean clumped) {
    this.foliageType = foliageType;
    this.clumped = clumped;
  }

  @Override
  public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {

  }

  public void generatePlants(Random random, World world, BlockPos from, BlockPos to, int attempts) {
    int xd = to.func_177958_n() - from.func_177958_n();
    int yd = to.func_177956_o() - from.func_177956_o();
    int zd = to.func_177952_p() - from.func_177952_p();

    IBlockState state = TinkerWorld.slimeGrassTall.func_176223_P().func_177226_a(BlockTallSlimeGrass.FOLIAGE, foliageType);

    for(int i = 0; i < attempts; i++) {
      BlockPos pos = from.func_177982_a(random.nextInt(xd), 0, random.nextInt(zd));
      if(clumped) {
        pos = pos.func_177982_a(-random.nextInt(xd), 0, -random.nextInt(zd));
      }

      for(int j = 0; j < yd && world.func_175623_d(pos.func_177977_b()); j++) {
        pos = pos.func_177977_b();
      }

      state = state.func_177231_a(BlockTallSlimeGrass.TYPE);

      // suitable position?
      if(world.func_175623_d(pos) && TinkerWorld.slimeGrassTall.func_180671_f(world, pos, state)) {
        world.func_180501_a(pos, state, 2);
      }
    }
  }
}
