package slimeknights.tconstruct.common;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.FakePlayer;

import slimeknights.tconstruct.TConstruct;

public final class PlayerHelper {
  private PlayerHelper() {}

  public static void spawnItemAtEntity (Entity entity, ItemStack stack, int delay)
  {
    if (!entity.field_70170_p.field_72995_K)
    {
      EntityItem entityitem = new EntityItem(entity.field_70170_p, entity.field_70165_t + 0.5D, entity.field_70163_u + 0.5D, entity.field_70161_v + 0.5D, stack);
      entityitem.func_174867_a(delay);
      entity.field_70170_p.func_72838_d(entityitem);
    }
  }

  public static void spawnItemAtPlayer (EntityPlayer player, ItemStack stack)
  {
    if (!player.field_70170_p.field_72995_K)
    {
      // try to put it into the players inventory
      if(player instanceof FakePlayer || !player.field_71071_by.func_70441_a(stack)) // note that the addItemStackToInventory is not called for fake players
      {
        // drop the rest as an entity
        EntityItem entityitem = new EntityItem(player.field_70170_p, player.field_70165_t + 0.5D, player.field_70163_u + 0.5D, player.field_70161_v + 0.5D, stack);
        player.field_70170_p.func_72838_d(entityitem);
        if (!(player instanceof FakePlayer))
          entityitem.func_70100_b_(player);
      }
      // if it got picked up, we're playing the sound
      else {
        player.field_70170_p.func_72956_a(player, "random.pop", 0.2F, ((TConstruct.random.nextFloat() - TConstruct.random.nextFloat()) * 0.7F + 1.0F) * 2.0F);
        if(player instanceof EntityPlayerMP)
          player.field_71069_bz.func_75142_b();
      }
    }

  }
}
