/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.common.PlayerHelper;
import slimeknights.tconstruct.smeltery.block.BlockEnumSmeltery;
import slimeknights.tconstruct.smeltery.tileentity.TileDrain;

public class BlockSmelteryIO
extends BlockEnumSmeltery<IOType> {
    public static final PropertyEnum<IOType> TYPE = PropertyEnum.func_177709_a((String)"type", IOType.class);
    public static PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockSmelteryIO() {
        super(TYPE, IOType.class);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{TYPE, FACING});
    }

    public IBlockState func_176203_a(int meta) {
        int horIndex = meta >> 2 & 0xF;
        return this.func_176223_P().func_177226_a((IProperty)this.prop, (Comparable)((Object)this.fromMeta(meta))).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[horIndex]);
    }

    public int func_176201_c(IBlockState state) {
        return ((IOType)((Object)state.func_177229_b((IProperty)this.prop))).getMeta() | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2;
    }

    public int func_180651_a(IBlockState state) {
        return ((IOType)((Object)state.func_177229_b((IProperty)this.prop))).getMeta();
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileDrain();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing side = placer.func_174811_aO().func_176734_d();
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)side);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler tank = (IFluidHandler)te;
        side = side.func_176734_d();
        ItemStack stack = player.func_70694_bm();
        if (stack == null) {
            return false;
        }
        ItemStack result = FluidUtil.tryEmptyBucket((ItemStack)stack, (IFluidHandler)tank, (EnumFacing)side);
        if (result != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                PlayerHelper.spawnItemAtPlayer(player, result);
            }
            return true;
        }
        ItemStack copy = stack.func_77946_l();
        if (FluidUtil.tryEmptyFluidContainerItem((ItemStack)stack, (IFluidHandler)tank, (EnumFacing)side, (EntityPlayer)player)) {
            if (player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, copy);
            }
            return true;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack) || stack.func_77973_b() instanceof IFluidContainerItem;
    }

    public static enum IOType implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        DRAIN;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString();
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

