/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.worldgen;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class SlimeIslandData
extends WorldSavedData {
    public final List<StructureBoundingBox> islands = Lists.newArrayList();

    public SlimeIslandData(String name) {
        super(name);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.islands.clear();
        NBTTagList tagList = nbt.getTagList("slimeislands", 11);
        for (int i = 0; i < tagList.tagCount(); ++i) {
            this.islands.add(new StructureBoundingBox(tagList.getIntArrayAt(i)));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (StructureBoundingBox sbb : this.islands) {
            tagList.appendTag((NBTBase)sbb.toNBTTagIntArray());
        }
        nbt.setTag("slimeislands", (NBTBase)tagList);
    }
}

