/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.traits;

import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import slimeknights.tconstruct.library.tools.ToolNBT;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.traits.TraitProgressiveStats;

public class TraitAlien
extends TraitProgressiveStats {
    protected static int TICK_PER_STAT = 72;
    protected static int DURABILITY_STEP = 1;
    protected static float SPEED_STEP = 0.007f;
    protected static float ATTACK_STEP = 0.005f;

    public TraitAlien() {
        super("alien", EnumChatFormatting.YELLOW);
    }

    @Override
    public void applyEffect(NBTTagCompound rootCompound, NBTTagCompound modifierTag) {
        if (!this.hasPool(rootCompound)) {
            TraitProgressiveStats.StatNBT data = new TraitProgressiveStats.StatNBT();
            block5: for (int statPoints = 800; statPoints > 0; --statPoints) {
                switch (random.nextInt(3)) {
                    case 0: {
                        data.durability += DURABILITY_STEP;
                        continue block5;
                    }
                    case 1: {
                        data.speed += SPEED_STEP;
                        continue block5;
                    }
                    case 2: {
                        data.attack += ATTACK_STEP;
                    }
                }
            }
            this.setPool(rootCompound, data);
        }
        super.applyEffect(rootCompound, modifierTag);
    }

    @Override
    public void onUpdate(ItemStack tool, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof FakePlayer || entity.worldObj.isRemote) {
            return;
        }
        if (entity.ticksExisted % TICK_PER_STAT > 0) {
            return;
        }
        if (this.playerIsBreakingBlock(entity)) {
            return;
        }
        NBTTagCompound root = TagUtil.getTagSafe(tool);
        TraitProgressiveStats.StatNBT pool = this.getPool(root);
        TraitProgressiveStats.StatNBT distributed = this.getBonus(root);
        ToolNBT data = TagUtil.getToolStats(tool);
        if (entity.ticksExisted % (TICK_PER_STAT * 3) == 0) {
            if (distributed.attack < pool.attack) {
                data.attack += ATTACK_STEP;
                distributed.attack += ATTACK_STEP;
            }
        } else if (entity.ticksExisted % (TICK_PER_STAT * 2) == 0) {
            if (distributed.speed < pool.speed) {
                data.speed += SPEED_STEP;
                distributed.speed += SPEED_STEP;
            }
        } else if (distributed.durability < pool.durability) {
            data.durability += DURABILITY_STEP;
            distributed.durability += DURABILITY_STEP;
        }
        TagUtil.setToolTag(root, data.get());
        this.setBonus(root, distributed);
    }
}

