/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.network.AbstractPacketThreadsafe;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tools.block.ITinkerStationBlock;

public class TinkerStationTabPacket
extends AbstractPacketThreadsafe {
    public int blockX;
    public int blockY;
    public int blockZ;

    public TinkerStationTabPacket() {
    }

    @SideOnly(value=Side.CLIENT)
    public TinkerStationTabPacket(BlockPos pos) {
        this.blockX = pos.getX();
        this.blockY = pos.getY();
        this.blockZ = pos.getZ();
    }

    public void handleClientSafe(NetHandlerPlayClient netHandler) {
        throw new UnsupportedOperationException("Serverside only");
    }

    public void handleServerSafe(NetHandlerPlayServer netHandler) {
        BlockPos pos;
        IBlockState state;
        EntityPlayerMP player = netHandler.playerEntity;
        ItemStack heldStack = null;
        if (player.inventory.getItemStack() != null) {
            heldStack = player.inventory.getItemStack();
            player.inventory.setItemStack(null);
        }
        if ((state = player.worldObj.getBlockState(pos = new BlockPos(this.blockX, this.blockY, this.blockZ))).getBlock() instanceof ITinkerStationBlock) {
            ((ITinkerStationBlock)state.getBlock()).openGui((EntityPlayer)player, player.worldObj, pos);
        } else {
            player.openGui((Object)TConstruct.instance, 0, player.worldObj, this.blockX, this.blockY, this.blockZ);
        }
        if (heldStack != null) {
            player.inventory.setItemStack(heldStack);
            netHandler.sendPacket((Packet)new S2FPacketSetSlot(-1, -1, heldStack));
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.blockX = buf.readInt();
        this.blockY = buf.readInt();
        this.blockZ = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.blockX);
        buf.writeInt(this.blockY);
        buf.writeInt(this.blockZ);
    }
}

