/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.inventory;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import slimeknights.mantle.inventory.ContainerMultiModule;
import slimeknights.tconstruct.smeltery.tileentity.TileSmeltery;
import slimeknights.tconstruct.tools.inventory.ContainerSideInventory;

public class ContainerSmeltery
extends ContainerMultiModule<TileSmeltery> {
    protected ContainerSideInventory<TileSmeltery> sideInventory;
    protected int[] oldHeats;

    public ContainerSmeltery(InventoryPlayer inventoryPlayer, TileSmeltery tile) {
        super((TileEntity)tile);
        this.sideInventory = new ContainerSideInventory<TileSmeltery>(tile, (IInventory)tile, 0, 0, this.calcColumns());
        this.addSubContainer((Container)this.sideInventory, true);
        this.addPlayerInventory(inventoryPlayer, 8, 84);
        this.oldHeats = new int[tile.getSizeInventory()];
    }

    public int calcColumns() {
        return 3;
    }

    public void onCraftGuiOpened(ICrafting listener) {
        super.onCraftGuiOpened(listener);
        for (int i = 0; i < this.oldHeats.length; ++i) {
            listener.sendProgressBarUpdate((Container)this, i, ((TileSmeltery)this.tile).getTemperature(i));
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        for (int i = 0; i < this.oldHeats.length; ++i) {
            int temp = ((TileSmeltery)this.tile).getTemperature(i);
            if (temp == this.oldHeats[i]) continue;
            this.oldHeats[i] = temp;
            for (ICrafting crafter : this.crafters) {
                crafter.sendProgressBarUpdate((Container)this, i, temp);
            }
        }
    }

    public void updateProgressBar(int id, int data) {
        ((TileSmeltery)this.tile).updateTemperatureFromPacket(id, data);
    }
}

