/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.events.TinkerEvent;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.MaterialItem;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.Pattern;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.library.utils.TinkerUtil;

public final class ToolBuilder {
    private static Logger log = Util.getLogger("ToolBuilder");

    private ToolBuilder() {
    }

    public static ItemStack tryBuildTool(ItemStack[] stacks, String name) {
        return ToolBuilder.tryBuildTool(stacks, name, TinkerRegistry.getTools());
    }

    public static ItemStack tryBuildTool(ItemStack[] stacks, String name, Collection<ToolCore> possibleTools) {
        int length = -1;
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) {
                if (length >= 0) continue;
                length = i;
                continue;
            }
            if (length < 0) continue;
            return null;
        }
        if (length < 0) {
            return null;
        }
        ItemStack[] input = Arrays.copyOf(stacks, length);
        for (Item item : possibleTools) {
            ItemStack output;
            if (!(item instanceof ToolCore) || (output = ((ToolCore)item).buildItemFromStacks(input)) == null) continue;
            if (name != null && !name.isEmpty()) {
                output.setStackDisplayName(name);
            }
            return output;
        }
        return null;
    }

    public static void addTrait(NBTTagCompound rootCompound, ITrait trait, int color) {
        if (TinkerRegistry.getTrait(trait.getIdentifier()) == null) {
            log.error("addTrait: Trying to apply unregistered Trait {}", new Object[]{trait.getIdentifier()});
            return;
        }
        IModifier modifier = TinkerRegistry.getModifier(trait.getIdentifier());
        if (modifier == null || !(modifier instanceof AbstractTrait)) {
            log.error("addTrait: No matching modifier for the Trait {} present", new Object[]{trait.getIdentifier()});
            return;
        }
        AbstractTrait traitModifier = (AbstractTrait)modifier;
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = TagUtil.getModifiersTagList(rootCompound);
        int index = TinkerUtil.getIndexInList(tagList, traitModifier.getModifierIdentifier());
        if (index < 0) {
            traitModifier.updateNBTforTrait(tag, color);
            tagList.appendTag((NBTBase)tag);
            TagUtil.setModifiersTagList(rootCompound, tagList);
        } else {
            tag = tagList.getCompoundTagAt(index);
        }
        traitModifier.applyEffect(rootCompound, tag);
    }

    public static ItemStack tryRepairTool(ItemStack[] stacks, ItemStack toolStack, boolean removeItems) {
        if (toolStack == null || !(toolStack.getItem() instanceof IRepairable)) {
            return null;
        }
        if (!removeItems) {
            stacks = Util.copyItemStackArray(stacks);
        }
        return ((IRepairable)toolStack.getItem()).repair(toolStack, stacks);
    }

    public static ItemStack tryModifyTool(ItemStack[] input, ItemStack toolStack, boolean removeItems) throws TinkerGuiException {
        int i;
        ItemStack copy = toolStack.copy();
        ItemStack[] stacks = Util.copyItemStackArray(input);
        ItemStack[] usedStacks = Util.copyItemStackArray(input);
        HashSet appliedModifiers = Sets.newHashSet();
        for (IModifier modifier : TinkerRegistry.getAllModifiers()) {
            RecipeMatch.Match match;
            do {
                match = modifier.matches(stacks);
                ItemStack backup = copy.copy();
                if (match == null) continue;
                while (match.amount > 0) {
                    TinkerGuiException caughtException = null;
                    boolean canApply = false;
                    try {
                        canApply = modifier.canApply(copy, toolStack);
                    }
                    catch (TinkerGuiException e) {
                        caughtException = e;
                    }
                    if (canApply) {
                        modifier.apply(copy);
                        appliedModifiers.add(modifier);
                        --match.amount;
                        continue;
                    }
                    if (caughtException != null && !appliedModifiers.contains(modifier)) {
                        throw caughtException;
                    }
                    copy = backup;
                    RecipeMatch.removeMatch((ItemStack[])stacks, (RecipeMatch.Match)match);
                    break;
                }
                if (match.amount != 0) continue;
                RecipeMatch.removeMatch((ItemStack[])stacks, (RecipeMatch.Match)match);
                RecipeMatch.removeMatch((ItemStack[])usedStacks, (RecipeMatch.Match)match);
            } while (match != null);
        }
        for (i = 0; i < input.length; ++i) {
            if (input[i] == null || !ItemStack.areItemStacksEqual((ItemStack)input[i], (ItemStack)stacks[i])) continue;
            if (!appliedModifiers.isEmpty()) {
                String error = StatCollector.translateToLocalFormatted((String)"gui.error.no_modifier_for_item", (Object[])new Object[]{input[i].getDisplayName()});
                throw new TinkerGuiException(error);
            }
            return null;
        }
        if (removeItems) {
            for (i = 0; i < input.length; ++i) {
                if (input[i] == null) continue;
                input[i].stackSize = usedStacks[i] == null ? 0 : usedStacks[i].stackSize;
            }
        }
        if (!appliedModifiers.isEmpty()) {
            if (copy.getItem() instanceof TinkersItem) {
                NBTTagCompound root = TagUtil.getTagSafe(copy);
                ToolBuilder.rebuildTool(root, (TinkersItem)copy.getItem());
                copy.setTagCompound(root);
            }
            return copy;
        }
        return null;
    }

    public static ItemStack tryReplaceToolParts(ItemStack toolStack, final ItemStack[] toolPartsIn, final boolean removeItems) throws TinkerGuiException {
        if (toolStack == null || !(toolStack.getItem() instanceof TinkersItem)) {
            return null;
        }
        final ItemStack[] toolParts = Util.copyItemStackArray(toolPartsIn);
        TIntIntHashMap assigned = new TIntIntHashMap();
        TinkersItem tool = (TinkersItem)toolStack.getItem();
        final NBTTagList materialList = (NBTTagList)TagUtil.getBaseMaterialsTagList(toolStack).copy();
        for (int i = 0; i < toolParts.length; ++i) {
            ItemStack part = toolParts[i];
            if (part == null) continue;
            if (!(part.getItem() instanceof IToolPart)) {
                return null;
            }
            int candidate = -1;
            List<PartMaterialType> pms = tool.getRequiredComponents();
            for (int j = 0; j < pms.size(); ++j) {
                PartMaterialType pmt = pms.get(j);
                String partMat = ((IToolPart)part.getItem()).getMaterial(part).getIdentifier();
                String currentMat = materialList.getStringTagAt(j);
                if (!pmt.isValid(part) || partMat.equals(currentMat) || assigned.valueCollection().contains(j)) continue;
                candidate = j;
                if (i > j) break;
            }
            if (candidate < 0) {
                return null;
            }
            assigned.put(i, candidate);
        }
        if (assigned.isEmpty()) {
            return null;
        }
        assigned.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int i, int j) {
                String mat = ((IToolPart)toolParts[i].getItem()).getMaterial(toolParts[i]).getIdentifier();
                materialList.set(j, (NBTBase)new NBTTagString(mat));
                if (removeItems) {
                    --toolPartsIn[i].stackSize;
                }
                return true;
            }
        });
        ItemStack output = toolStack.copy();
        TagUtil.setBaseMaterialsTagList(output, materialList);
        NBTTagCompound tag = output.getTagCompound();
        ToolBuilder.rebuildTool(tag, (TinkersItem)output.getItem());
        output.setTagCompound(tag);
        if (output.getItemDamage() > output.getMaxDamage()) {
            String error = StatCollector.translateToLocalFormatted((String)"gui.error.not_enough_durability", (Object[])new Object[]{output.getItemDamage() - output.getMaxDamage()});
            throw new TinkerGuiException(error);
        }
        return output;
    }

    public static ItemStack[] tryBuildToolPart(ItemStack pattern, ItemStack[] materialItems, boolean removeItems) throws TinkerGuiException {
        Item itemPart = Pattern.getPartFromTag(pattern);
        if (itemPart == null || !(itemPart instanceof MaterialItem) || !(itemPart instanceof IToolPart)) {
            String error = StatCollector.translateToLocalFormatted((String)"gui.error.invalid_pattern", (Object[])new Object[0]);
            throw new TinkerGuiException(error);
        }
        IToolPart part = (IToolPart)itemPart;
        if (!removeItems) {
            materialItems = Util.copyItemStackArray(materialItems);
        }
        RecipeMatch.Match match = null;
        Material foundMaterial = null;
        for (Material material : TinkerRegistry.getAllMaterials()) {
            RecipeMatch.Match newMatch;
            if (!material.isCraftable() || (newMatch = material.matches(materialItems, part.getCost())) == null) continue;
            if (match == null) {
                match = newMatch;
                foundMaterial = material;
                continue;
            }
            if (newMatch.stacks.size() <= match.stacks.size()) continue;
            match = newMatch;
            foundMaterial = material;
        }
        if (match == null) {
            return null;
        }
        ItemStack output = ((MaterialItem)itemPart).getItemstackWithMaterial(foundMaterial);
        if (output == null) {
            return null;
        }
        RecipeMatch.removeMatch((ItemStack[])materialItems, match);
        ItemStack secondary = null;
        int leftover = (match.amount - part.getCost()) / 72;
        if (leftover > 0) {
            secondary = TinkerRegistry.getShard(foundMaterial);
            secondary.stackSize = leftover;
        }
        return new ItemStack[]{output, secondary};
    }

    public static void rebuildTool(NBTTagCompound rootNBT, TinkersItem tinkersItem) throws TinkerGuiException {
        boolean broken = TagUtil.getToolTag(rootNBT).getBoolean("Broken");
        NBTTagList materialTag = TagUtil.getBaseMaterialsTagList(rootNBT);
        List<Material> materials = TinkerUtil.getMaterialsFromTagList(materialTag);
        List<PartMaterialType> pms = tinkersItem.getRequiredComponents();
        while (materials.size() < pms.size()) {
            materials.add(Material.UNKNOWN);
        }
        for (int i = 0; i < pms.size(); ++i) {
            if (pms.get(i).isValidMaterial(materials.get(i))) continue;
            materials.set(i, Material.UNKNOWN);
        }
        NBTTagCompound toolTag = tinkersItem.buildTag(materials);
        TagUtil.setToolTag(rootNBT, toolTag);
        rootNBT.setTag("StatsOriginal", toolTag.copy());
        NBTTagList modifiersTagOld = TagUtil.getModifiersTagList(rootNBT);
        rootNBT.removeTag("Modifiers");
        rootNBT.setTag("Modifiers", (NBTBase)new NBTTagList());
        rootNBT.removeTag("ench");
        rootNBT.removeTag("EnchantEffect");
        rootNBT.removeTag("Traits");
        tinkersItem.addMaterialTraits(rootNBT, materials);
        TinkerEvent.OnItemBuilding.fireEvent(rootNBT, (ImmutableList<Material>)ImmutableList.copyOf(materials));
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(rootNBT);
        NBTTagList modifiersTag = TagUtil.getModifiersTagList(rootNBT);
        for (int i = 0; i < modifiers.tagCount(); ++i) {
            String identifier = modifiers.getStringTagAt(i);
            IModifier modifier = TinkerRegistry.getModifier(identifier);
            if (modifier == null) {
                log.debug("Missing modifier: {}", new Object[]{identifier});
                continue;
            }
            int index = TinkerUtil.getIndexInList(modifiersTagOld, modifier.getIdentifier());
            NBTTagCompound tag = index >= 0 ? modifiersTagOld.getCompoundTagAt(index) : new NBTTagCompound();
            modifier.applyEffect(rootNBT, tag);
            if (tag.hasNoTags()) continue;
            modifiersTag.appendTag((NBTBase)tag);
        }
        toolTag = TagUtil.getToolTag(rootNBT);
        int freeModifiers = toolTag.getInteger("FreeModifiers");
        toolTag.setInteger("FreeModifiers", Math.max(0, freeModifiers -= TagUtil.getBaseModifiersUsed(rootNBT)));
        if (broken) {
            toolTag.setBoolean("Broken", true);
        }
        TagUtil.setToolTag(rootNBT, toolTag);
        if (freeModifiers < 0) {
            throw new TinkerGuiException(Util.translateFormatted("gui.error.not_enough_modifiers", -freeModifiers));
        }
    }

    public static short getEnchantmentLevel(NBTTagCompound rootTag, Enchantment enchantment) {
        NBTTagList enchantments = rootTag.getTagList("ench", 10);
        if (enchantments == null) {
            enchantments = new NBTTagList();
        }
        for (int i = 0; i < enchantments.tagCount(); ++i) {
            if (enchantments.getCompoundTagAt(i).getShort("id") != enchantment.effectId) continue;
            return enchantments.getCompoundTagAt(i).getShort("lvl");
        }
        return 0;
    }

    public static void addEnchantment(NBTTagCompound rootTag, Enchantment enchantment) {
        NBTTagList enchantments = rootTag.getTagList("ench", 10);
        if (enchantments == null) {
            enchantments = new NBTTagList();
        }
        NBTTagCompound enchTag = new NBTTagCompound();
        int id = -1;
        for (int i = 0; i < enchantments.tagCount(); ++i) {
            if (enchantments.getCompoundTagAt(i).getShort("id") != enchantment.effectId) continue;
            enchTag = enchantments.getCompoundTagAt(i);
            id = i;
            break;
        }
        int level = enchTag.getShort("lvl") + 1;
        level = Math.min(level, enchantment.getMaxLevel());
        enchTag.setShort("id", (short)enchantment.effectId);
        enchTag.setShort("lvl", (short)level);
        if (id < 0) {
            enchantments.appendTag((NBTBase)enchTag);
        } else {
            enchantments.set(id, (NBTBase)enchTag);
        }
        rootTag.setTag("ench", (NBTBase)enchantments);
    }
}

