/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.potion;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public class TinkerPotion
extends Potion {
    private final boolean show;

    public TinkerPotion(ResourceLocation location, boolean badEffect, boolean showInInventory) {
        this(location, badEffect, showInInventory, 0xFFFFFF);
    }

    public TinkerPotion(ResourceLocation location, boolean badEffect, boolean showInInventory, int color) {
        super(location, badEffect, color);
        this.setPotionName("potion." + location.getResourcePath());
        this.show = showInInventory;
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return this.show;
    }

    public PotionEffect apply(EntityLivingBase entity, int duration) {
        return this.apply(entity, duration, 0);
    }

    public PotionEffect apply(EntityLivingBase entity, int duration, int level) {
        PotionEffect effect = new PotionEffect(this.getId(), duration, level, false, false);
        entity.addPotionEffect(effect);
        return effect;
    }

    public int getLevel(EntityLivingBase entity) {
        PotionEffect effect = entity.getActivePotionEffect((Potion)this);
        if (effect != null) {
            return effect.getAmplifier();
        }
        return 0;
    }

    public boolean shouldRender(PotionEffect effect) {
        return this.show;
    }
}

