/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.collect.ImmutableList;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerMaterials;
import slimeknights.tconstruct.tools.TinkerTools;

public class CompareVanilla
extends CommandBase {
    public int getRequiredPermissionLevel() {
        return 0;
    }

    public String getCommandName() {
        return "compareVanilla";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "";
    }

    public void processCommand(ICommandSender sender, String[] args) throws CommandException {
        ImmutableList woodMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.wood));
        ImmutableList stoneMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.stone), (Object)((Object)TinkerMaterials.stone));
        ImmutableList ironMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.iron), (Object)((Object)TinkerMaterials.iron));
        ImmutableList cobaltMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.cobalt), (Object)((Object)TinkerMaterials.cobalt));
        ImmutableList manyMaterials = ImmutableList.of((Object)((Object)TinkerMaterials.wood), (Object)((Object)TinkerMaterials.manyullyn), (Object)((Object)TinkerMaterials.manyullyn));
        ItemStack wood = TinkerTools.pickaxe.buildItem((List<Material>)woodMaterials);
        ItemStack stone = TinkerTools.pickaxe.buildItem((List<Material>)stoneMaterials);
        ItemStack iron = TinkerTools.pickaxe.buildItem((List<Material>)ironMaterials);
        ItemStack extra = TinkerTools.pickaxe.buildItem((List<Material>)cobaltMaterials);
        this.testTools(Blocks.cobblestone, wood, stone, iron, extra, new ItemStack(Items.wooden_pickaxe), new ItemStack(Items.stone_pickaxe), new ItemStack(Items.iron_pickaxe), new ItemStack(Items.diamond_pickaxe), new ItemStack(Items.golden_pickaxe));
        wood = TinkerTools.shovel.buildItem((List<Material>)woodMaterials);
        stone = TinkerTools.shovel.buildItem((List<Material>)stoneMaterials);
        iron = TinkerTools.shovel.buildItem((List<Material>)ironMaterials);
        extra = TinkerTools.shovel.buildItem((List<Material>)cobaltMaterials);
        this.testTools(Blocks.dirt, wood, stone, iron, extra, new ItemStack(Items.wooden_shovel), new ItemStack(Items.stone_shovel), new ItemStack(Items.iron_shovel), new ItemStack(Items.diamond_shovel), new ItemStack(Items.golden_shovel));
        wood = TinkerTools.hatchet.buildItem((List<Material>)woodMaterials);
        stone = TinkerTools.hatchet.buildItem((List<Material>)stoneMaterials);
        iron = TinkerTools.hatchet.buildItem((List<Material>)ironMaterials);
        extra = TinkerTools.hatchet.buildItem((List<Material>)cobaltMaterials);
        this.testTools(Blocks.log, wood, stone, iron, extra, new ItemStack(Items.wooden_axe), new ItemStack(Items.stone_axe), new ItemStack(Items.iron_axe), new ItemStack(Items.diamond_axe), new ItemStack(Items.golden_axe));
        wood = TinkerTools.broadSword.buildItem((List<Material>)woodMaterials);
        stone = TinkerTools.broadSword.buildItem((List<Material>)stoneMaterials);
        iron = TinkerTools.broadSword.buildItem((List<Material>)ironMaterials);
        extra = TinkerTools.broadSword.buildItem((List<Material>)manyMaterials);
        this.testTools(Blocks.melon_block, wood, stone, iron, extra, new ItemStack(Items.wooden_sword), new ItemStack(Items.stone_sword), new ItemStack(Items.iron_sword), new ItemStack(Items.diamond_sword), new ItemStack(Items.golden_sword));
    }

    protected void testTools(Block block, ItemStack wood, ItemStack stone, ItemStack iron, ItemStack extra1, ItemStack vanillaWood, ItemStack vanillaStone, ItemStack vanillaIron, ItemStack vanillaDiamond, ItemStack vanillaGold) {
        PrintWriter pw;
        File file = new File("test/" + wood.getItem().getClass().getSimpleName() + ".html");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            pw = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        pw.println("<html>");
        pw.println("<head>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<table border=\"1\">");
        pw.println(this.genSection("Wood", "#806517"));
        this.performToolTests(pw, block, wood, vanillaWood);
        pw.println(this.genSection("Stone", "#837E7C"));
        this.performToolTests(pw, block, stone, vanillaStone);
        pw.println(this.genSection("Iron", "#CECECE"));
        this.performToolTests(pw, block, iron, vanillaIron);
        pw.println(this.genSection("Diamond", "#5CB3FF"));
        this.performToolTests(pw, block, extra1, vanillaDiamond);
        pw.println(this.genSection("Gold", "#EAC117"));
        this.performToolTests(pw, block, extra1, vanillaGold);
        pw.println("</table>");
        pw.println("</body>");
        pw.println("<html>");
        pw.close();
    }

    protected void performToolTests(PrintWriter pw, Block block, ItemStack tinker, ItemStack vanilla) {
        pw.println(this.genHeader("", tinker.getDisplayName(), vanilla.getDisplayName()));
        pw.println(this.genSection("Unmodified", ""));
        pw.println(this.testTool(block, tinker, vanilla));
        pw.println(this.genSection("Haste/Efficiency V", ""));
        ItemStack tinkerModified = this.applyModifier(TinkerTools.modHaste, tinker);
        ItemStack vanillaModified = this.applyEnchantment(Enchantment.efficiency, vanilla);
        pw.println(this.testToolSpeed(block, tinkerModified, vanillaModified));
        pw.println(this.genSection("Sharpness V", ""));
        tinkerModified = this.applyModifier(TinkerTools.modSharpness, tinker);
        vanillaModified = this.applyEnchantment(Enchantment.sharpness, vanilla);
        pw.println(this.testToolAttack(tinkerModified, vanillaModified));
    }

    protected ItemStack applyModifier(IModifier modifier, ItemStack tool) {
        tool = tool.copy();
        try {
            while (modifier.canApply(tool, tool)) {
                modifier.apply(tool);
            }
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
        try {
            ToolBuilder.rebuildTool(tool.getTagCompound(), (TinkersItem)tool.getItem());
        }
        catch (TinkerGuiException tinkerGuiException) {
            // empty catch block
        }
        return tool;
    }

    protected ItemStack applyEnchantment(Enchantment enchantment, ItemStack tool) {
        tool = tool.copy();
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < enchantment.getMaxLevel(); ++i) {
            ToolBuilder.addEnchantment(tag, enchantment);
        }
        tool.setTagCompound(tag);
        return tool;
    }

    protected String testTool(Block block, ItemStack tinker, ItemStack vanilla) {
        return this.testToolDurability(tinker, vanilla) + this.testToolSpeed(block, tinker, vanilla) + this.testToolAttack(tinker, vanilla);
    }

    protected String testToolDurability(ItemStack tinker, ItemStack vanilla) {
        int durability1 = tinker.getMaxDamage();
        int durability2 = vanilla.getMaxDamage();
        return this.genRow("Durability", durability1, durability2);
    }

    protected String testToolSpeed(Block block, ItemStack tinker, ItemStack vanilla) {
        IBlockState state = block.getDefaultState();
        float speed1 = tinker.getItem().getDigSpeed(tinker, state);
        float speed2 = vanilla.getItem().getDigSpeed(vanilla, state);
        int efficiencyLevel = EnchantmentHelper.getEnchantmentLevel((int)Enchantment.efficiency.effectId, (ItemStack)vanilla);
        if (efficiencyLevel > 0) {
            speed2 += (float)(efficiencyLevel * efficiencyLevel + 1);
        }
        return this.genRow("Speed", Float.valueOf(speed1), Float.valueOf(speed2));
    }

    protected String testToolAttack(ItemStack tinker, ItemStack vanilla) {
        float attack1 = ToolHelper.getActualDamage(tinker, (EntityPlayer)Minecraft.getMinecraft().thePlayer);
        float attack2 = 1.0f;
        for (AttributeModifier mod : vanilla.getItem().getAttributeModifiers(vanilla).get((Object)SharedMonsterAttributes.attackDamage.getAttributeUnlocalizedName())) {
            attack2 = (float)((double)attack2 + mod.getAmount());
        }
        return this.genRow("Attack", Float.valueOf(attack1), Float.valueOf(attack2 += EnchantmentHelper.func_152377_a((ItemStack)vanilla, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED)));
    }

    private String genHeader(String desc, Object v1, Object v2) {
        return "<tr><th>" + desc + "</th><th>" + v1 + "</th><th>" + v2 + "</th></tr>";
    }

    private String genSection(String desc, String color) {
        return "<tr><td colspan=\"3\" align=\"center\" bgcolor=\"" + color + "\">" + desc + "</td></tr>";
    }

    private String genRow(String desc, Number v1, Number v2) {
        Number max = v1.floatValue() > v2.floatValue() ? (Number)v1 : (Number)v2;
        String c1 = Integer.toHexString(this.floatToCol(v1.floatValue() / max.floatValue()));
        String c2 = Integer.toHexString(this.floatToCol(v2.floatValue() / max.floatValue()));
        return "<tr><td bgcolor=\"lightgray\">" + desc + "</td><td bgcolor=\"" + c1 + "\">" + v1 + "</td><td bgcolor=\"" + c2 + "\">" + v2 + "</td></tr>";
    }

    private int floatToCol(float f) {
        return Color.HSBtoRGB(f / 3.0f, 0.65f, 0.8f) & 0xFFFFFF;
    }
}

