/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.client.module;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.mantle.client.gui.GuiMultiModule;
import slimeknights.mantle.client.gui.GuiWidgetSlider;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.tools.client.module.GuiGeneric;
import slimeknights.tconstruct.tools.client.module.GuiWidgetBorder;

@SideOnly(value=Side.CLIENT)
public class GuiSideInventory
extends GuiModule {
    protected GuiElementScalable overlap = GuiGeneric.overlap;
    protected GuiElement overlapTopLeft = GuiGeneric.overlapTopLeft;
    protected GuiElement overlapTopRight = GuiGeneric.overlapTopRight;
    protected GuiElement overlapBottomLeft = GuiGeneric.overlapBottomLeft;
    protected GuiElement overlapBottomRight = GuiGeneric.overlapBottomRight;
    protected GuiElement overlapTop = new GuiElement(7, 0, 7, 7, 64, 64);
    protected GuiElementScalable textBackground = GuiGeneric.textBackground;
    protected GuiElementScalable slot = GuiGeneric.slot;
    protected GuiElementScalable slotEmpty = GuiGeneric.slotEmpty;
    protected GuiElement sliderNormal = GuiGeneric.sliderNormal;
    protected GuiElement sliderLow = GuiGeneric.sliderLow;
    protected GuiElement sliderHigh = GuiGeneric.sliderHigh;
    protected GuiElement sliderTop = GuiGeneric.sliderTop;
    protected GuiElement sliderBottom = GuiGeneric.sliderBottom;
    protected GuiElementScalable sliderBackground = GuiGeneric.sliderBackground;
    protected static final ResourceLocation GUI_INVENTORY = Util.getResource("textures/gui/generic.png");
    protected GuiWidgetBorder border = new GuiWidgetBorder();
    protected int columns;
    protected int slotCount;
    protected int firstSlotId;
    protected int lastSlotId;
    protected int yOffset = 5;
    protected int xOffset;
    protected boolean connected;
    protected GuiWidgetSlider slider = new GuiWidgetSlider(this.sliderNormal, this.sliderHigh, this.sliderLow, this.sliderTop, this.sliderBottom, this.sliderBackground);

    public GuiSideInventory(GuiMultiModule parent, Container container, int slotCount, int columns) {
        this(parent, container, slotCount, columns, false, false);
    }

    public GuiSideInventory(GuiMultiModule parent, Container container, int slotCount, int columns, boolean rightSide, boolean connected) {
        super(parent, container, rightSide, false);
        this.connected = connected;
        this.columns = columns;
        this.slotCount = slotCount;
        this.field_146999_f = columns * this.slot.w + this.border.w * 2;
        this.field_147000_g = this.calcCappedYSize(this.slot.h * 10);
        if (connected) {
            if (this.right) {
                this.border.cornerTopLeft = this.overlapTopLeft;
                this.border.borderLeft = this.overlap;
                this.border.cornerBottomLeft = this.overlapBottomLeft;
            } else {
                this.border.cornerTopRight = this.overlapTopRight;
                this.border.borderRight = this.overlap;
                this.border.cornerBottomRight = this.overlapBottomRight;
            }
        }
        this.yOffset = 0;
        this.updateSlots();
    }

    protected boolean shouldDrawName() {
        if (this.field_147002_h instanceof BaseContainer) {
            return ((BaseContainer)this.field_147002_h).getInventoryDisplayName() != null;
        }
        return false;
    }

    public boolean shouldDrawSlot(Slot slot) {
        if (slot.getSlotIndex() >= this.slotCount) {
            return false;
        }
        if (!this.slider.isEnabled()) {
            return true;
        }
        return this.firstSlotId <= slot.getSlotIndex() && this.lastSlotId > slot.getSlotIndex();
    }

    public boolean func_146981_a(Slot slotIn, int mouseX, int mouseY) {
        return super.func_146981_a(slotIn, mouseX, mouseY) && this.shouldDrawSlot(slotIn);
    }

    public void updateSlotCount(int newSlotCount) {
        if (this.slotCount == newSlotCount) {
            return;
        }
        this.slotCount = newSlotCount;
        this.updatePosition(this.parent.cornerX, this.parent.cornerY, this.parent.realWidth, this.parent.realHeight);
        this.updatePosition(this.parent.cornerX, this.parent.cornerY, this.parent.realWidth, this.parent.realHeight);
    }

    public void updatePosition(int parentX, int parentY, int parentSizeX, int parentSizeY) {
        this.field_147000_g = this.calcCappedYSize(parentSizeY - 10);
        if (this.getDisplayedRows() < this.getTotalRows()) {
            this.slider.enable();
            this.field_146999_f = this.columns * this.slot.w + this.slider.width + 2 * this.border.w;
        } else {
            this.slider.disable();
            this.field_146999_f = this.columns * this.slot.w + this.border.w * 2;
        }
        super.updatePosition(parentX, parentY, parentSizeX, parentSizeY);
        if (this.connected) {
            if (this.yOffset == 0) {
                if (this.right) {
                    this.border.cornerTopLeft = this.overlapTop;
                } else {
                    this.border.cornerTopRight = this.overlapTop;
                }
            }
            this.xOffset = (this.border.w - 1) * (this.right ? -1 : 1);
            this.field_147003_i += this.xOffset;
        } else {
            this.xOffset = 0;
        }
        this.field_147009_r += this.yOffset;
        this.border.setPosition(this.field_147003_i, this.field_147009_r);
        this.border.setSize(this.field_146999_f, this.field_147000_g);
        int y = this.field_147009_r + this.border.h;
        int h = this.field_147000_g - this.border.h * 2;
        if (this.shouldDrawName()) {
            y += this.textBackground.h;
            h -= this.textBackground.h;
        }
        this.slider.setPosition(this.field_147003_i + this.columns * this.slot.w + this.border.w, y);
        this.slider.setSize(h);
        this.slider.setSliderParameters(0, this.getTotalRows() - this.getDisplayedRows(), 1);
        this.updateSlots();
    }

    private int getDisplayedRows() {
        return this.slider.height / this.slot.h;
    }

    private int getTotalRows() {
        int total = this.slotCount / this.columns;
        if (this.slotCount % this.columns != 0) {
            ++total;
        }
        return total;
    }

    private int calcCappedYSize(int max) {
        int h = this.slot.h * this.getTotalRows();
        h = this.border.getHeightWithBorder(h);
        if (this.shouldDrawName()) {
            h += this.textBackground.h;
        }
        while (h > max) {
            h -= this.slot.h;
        }
        return h;
    }

    protected void updateSlots() {
        this.firstSlotId = this.slider.getValue() * this.columns;
        this.lastSlotId = Math.min(this.slotCount, this.firstSlotId + this.getDisplayedRows() * this.columns);
        int xd = this.border.w + this.xOffset;
        int yd = this.border.h + this.yOffset;
        if (this.shouldDrawName()) {
            yd += this.textBackground.h;
        }
        for (Object o : this.field_147002_h.field_75151_b) {
            Slot slot = (Slot)o;
            if (this.shouldDrawSlot(slot)) {
                int offset = slot.getSlotIndex() - this.firstSlotId;
                int x = offset % this.columns * this.slot.w;
                int y = offset / this.columns * this.slot.h;
                slot.field_75223_e = xd + x + 1;
                slot.field_75221_f = yd + y + 1;
                if (this.right) {
                    slot.field_75223_e += this.parent.realWidth;
                    continue;
                }
                slot.field_75223_e -= this.field_146999_f;
                continue;
            }
            slot.field_75223_e = 0;
            slot.field_75221_f = 0;
        }
    }

    public void func_146979_b(int mouseX, int mouseY) {
        if (this.shouldDrawName()) {
            String name = ((BaseContainer)this.field_147002_h).getInventoryDisplayName().func_150260_c();
            this.field_146289_q.func_78276_b(name, this.border.w, this.border.h - 1, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.field_147003_i += this.border.w;
        this.field_147009_r += this.border.h;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_INVENTORY);
        int x = this.field_147003_i;
        int y = this.field_147009_r;
        int midW = this.field_146999_f - this.border.w * 2;
        int midH = this.field_147000_g - this.border.h * 2;
        this.border.draw();
        if (this.shouldDrawName()) {
            this.textBackground.drawScaledX(x, y, midW);
            y += this.textBackground.h;
        }
        this.field_146297_k.func_110434_K().func_110577_a(GUI_INVENTORY);
        this.drawSlots(x, y);
        if (this.slider.isEnabled()) {
            this.slider.update(mouseX, mouseY, !this.isMouseOverFullSlot(mouseX, mouseY) && this.isMouseInModule(mouseX, mouseY));
            this.slider.draw();
            this.updateSlots();
        }
        this.field_147003_i -= this.border.w;
        this.field_147009_r -= this.border.h;
    }

    protected int drawSlots(int xPos, int yPos) {
        int y;
        int width = this.columns * this.slot.w;
        int height = this.field_147000_g - this.border.h * 2;
        int fullRows = (this.lastSlotId - this.firstSlotId) / this.columns;
        for (y = 0; y < fullRows * this.slot.h && y < height; y += this.slot.h) {
            this.slot.drawScaledX(xPos, yPos + y, width);
        }
        int slotsLeft = (this.lastSlotId - this.firstSlotId) % this.columns;
        if (slotsLeft > 0) {
            this.slot.drawScaledX(xPos, yPos + y, slotsLeft * this.slot.w);
            this.slotEmpty.drawScaledX(xPos + slotsLeft * this.slot.w, yPos + y, width - slotsLeft * this.slot.w);
        }
        return width;
    }
}

