/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.tileentity;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.common.FMLCommonHandler;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.common.PlayerHelper;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.shared.tileentity.TileTable;
import slimeknights.tconstruct.smeltery.events.TinkerCastingEvent;
import slimeknights.tconstruct.smeltery.network.FluidUpdatePacket;

public abstract class TileCasting
extends TileTable
implements ITickable,
ISidedInventory,
IFluidHandler {
    public FluidTank tank = new FluidTank(0);
    public float renderOffset;
    protected int timer;
    protected CastingRecipe recipe;

    public TileCasting() {
        super("casting", 2, 1);
    }

    public void interact(EntityPlayer player) {
        if (this.tank.getFluidAmount() > 0) {
            return;
        }
        if (!this.isStackInSlot(0) && !this.isStackInSlot(1)) {
            ItemStack stack = player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, this.stackSizeLimit);
            this.func_70299_a(0, stack);
        } else {
            int slot = this.isStackInSlot(1) ? 1 : 0;
            ItemStack stack = this.func_70301_a(slot);
            if (slot == 1) {
                FMLCommonHandler.instance().firePlayerSmeltedEvent(player, stack);
            }
            PlayerHelper.spawnItemAtPlayer(player, stack);
            this.func_70299_a(slot, null);
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1};
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public void func_73660_a() {
        if (this.recipe == null) {
            return;
        }
        if (this.tank.getFluidAmount() == this.tank.getCapacity()) {
            ++this.timer;
            if (!this.field_145850_b.field_72995_K) {
                if (this.timer >= this.recipe.getTime()) {
                    TinkerCastingEvent.OnCasted event = TinkerCastingEvent.OnCasted.fire(this.recipe, this);
                    if (event.consumeCast) {
                        this.func_70299_a(0, null);
                    }
                    if (event.switchOutputs) {
                        this.func_70299_a(1, this.func_70301_a(0));
                        this.func_70299_a(0, event.output);
                    } else {
                        this.func_70299_a(1, event.output);
                    }
                    this.field_145850_b.func_72908_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), "random.fizz", 0.07f, 4.0f);
                    this.reset();
                }
            } else if (this.field_145850_b.field_73012_v.nextFloat() > 0.9f) {
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public float getCooldownProgress() {
        if (this.recipe == null || this.tank.getFluidAmount() == 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)this.timer / (float)this.recipe.getTime());
    }

    public ItemStack getCurrentResult() {
        if (this.recipe == null) {
            return null;
        }
        return this.recipe.getResult();
    }

    protected abstract CastingRecipe findRecipe(ItemStack var1, Fluid var2);

    protected CastingRecipe findRecipe(Fluid fluid) {
        CastingRecipe recipe = this.findRecipe(this.func_70301_a(0), fluid);
        if (TinkerCastingEvent.OnCasting.fire(recipe, this)) {
            return recipe;
        }
        return null;
    }

    protected void reset() {
        this.timer = 0;
        this.recipe = null;
        this.tank.setCapacity(0);
        this.tank.setFluid(null);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
            TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new FluidUpdatePacket(this.field_174879_c, null));
        }
    }

    public void updateFluidTo(FluidStack fluid) {
        int oldAmount = this.tank.getFluidAmount();
        this.tank.setFluid(fluid);
        if (fluid == null) {
            this.reset();
        } else if (this.recipe == null) {
            this.recipe = this.findRecipe(fluid.getFluid());
            if (this.recipe != null) {
                this.tank.setCapacity(this.recipe.getFluid().amount);
            }
        }
        this.renderOffset += (float)(this.tank.getFluidAmount() - oldAmount);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        if (this.isStackInSlot(1)) {
            return false;
        }
        if (this.tank.getFluidAmount() > 0) {
            return this.tank.getFluid().getFluid() == fluid && this.tank.getFluidAmount() < this.tank.getCapacity();
        }
        return this.findRecipe(fluid) != null;
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return this.timer == 0 && this.tank.getFluid() != null && this.tank.getFluid().getFluid() == fluid;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (!this.canFill(from, resource.getFluid())) {
            return 0;
        }
        if (this.tank.getFluidAmount() == 0) {
            int filled;
            CastingRecipe recipe = this.findRecipe(resource.getFluid());
            if (recipe == null) {
                return 0;
            }
            int capacity = recipe.getFluid().amount;
            FluidTank calcTank = new FluidTank(capacity);
            if (doFill) {
                this.recipe = recipe;
                this.tank.setCapacity(capacity);
                calcTank = this.tank;
            }
            if ((filled = calcTank.fill(resource, doFill)) > 0 && doFill) {
                this.renderOffset = filled;
                if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
                    TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new FluidUpdatePacket(this.field_174879_c, this.tank.getFluid()));
                }
            }
            return filled;
        }
        int filled = this.tank.fill(resource, doFill);
        if (filled > 0 && doFill) {
            this.renderOffset += (float)filled;
            if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
                TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new FluidUpdatePacket(this.field_174879_c, this.tank.getFluid()));
            }
        }
        return filled;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.tank.getFluidAmount() == 0) {
            return null;
        }
        if (this.tank.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.renderOffset = -maxDrain;
            if (!this.field_145850_b.field_72995_K && this.field_145850_b instanceof WorldServer) {
                TinkerNetwork.sendToClients((WorldServer)this.field_145850_b, this.field_174879_c, (AbstractPacket)new FluidUpdatePacket(this.field_174879_c, this.tank.getFluid()));
            }
            this.reset();
        }
        return amount;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    public void func_145841_b(NBTTagCompound tags) {
        super.func_145841_b(tags);
        NBTTagCompound tankTag = new NBTTagCompound();
        this.tank.writeToNBT(tankTag);
        tags.func_74782_a("tank", (NBTBase)tankTag);
        tags.func_74768_a("timer", this.timer);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.tank.readFromNBT(tags.func_74775_l("tank"));
        this.updateFluidTo(this.tank.getFluid());
        this.timer = tags.func_74762_e("timer");
    }
}

