package slimeknights.tconstruct.world.worldgen;

import com.google.common.collect.Lists;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.gen.structure.StructureBoundingBox;

import java.util.List;

public class SlimeIslandData extends WorldSavedData {

  public final List<StructureBoundingBox> islands = Lists.newArrayList();

  public SlimeIslandData(String name) {
    super(name);
  }

  @Override
  public void func_76184_a(NBTTagCompound nbt) {
    islands.clear();

    NBTTagList tagList = nbt.func_150295_c("slimeislands", 11);
    for(int i = 0; i < tagList.func_74745_c(); i++) {
      islands.add(new StructureBoundingBox(tagList.func_150306_c(i)));
    }
  }

  @Override
  public void func_76187_b(NBTTagCompound nbt) {
    NBTTagList tagList = new NBTTagList();
    for(StructureBoundingBox sbb : islands) {
      tagList.func_74742_a(sbb.func_151535_h());
    }

    nbt.func_74782_a("slimeislands", tagList);
  }
}
