package slimeknights.tconstruct.world.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import java.util.List;
import java.util.Random;

import slimeknights.mantle.block.EnumBlock;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class BlockSlimeGrass extends BlockGrass {
  public static PropertyEnum<DirtType> TYPE = PropertyEnum.func_177709_a("type", DirtType.class);
  public static PropertyEnum<FoliageType> FOLIAGE = PropertyEnum.func_177709_a("foliage", FoliageType.class);

  public BlockSlimeGrass() {
    this.func_149647_a(TinkerRegistry.tabWorld);
    this.func_149711_c(0.65f);
    this.func_149672_a(field_149779_h);
    this.field_149765_K += 0.05f;
  }

  @SideOnly(Side.CLIENT)
  @Override
  public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
    for(FoliageType grass : FoliageType.values()) {
      for(DirtType type : DirtType.values()) {
        list.add(new ItemStack(this, 1, func_176201_c(func_176223_P().func_177226_a(TYPE, type).func_177226_a(FOLIAGE, grass))));
      }
    }
  }

  @Override
  public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
    BlockPos blockpos1 = pos.func_177984_a();
    int i = 0;

    while (i < 128)
    {
      BlockPos blockpos2 = blockpos1;
      int j = 0;

      while (true)
      {
        if (j < i / 16)
        {
          blockpos2 = blockpos2.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1);

          if (worldIn.func_180495_p(blockpos2.func_177977_b()).func_177230_c() == this && !worldIn.func_180495_p(blockpos2).func_177230_c().func_149721_r())
          {
            ++j;
            continue;
          }
        }
        else if (worldIn.func_175623_d(blockpos2))
        {
          IBlockState plantState;
          if (rand.nextInt(8) == 0)
          {
            plantState = TinkerWorld.slimeGrassTall.func_176223_P().func_177226_a(BlockTallSlimeGrass.TYPE, BlockTallSlimeGrass.SlimePlantType.FERN);
          }
          else
          {
            plantState = TinkerWorld.slimeGrassTall.func_176223_P().func_177226_a(BlockTallSlimeGrass.TYPE, BlockTallSlimeGrass.SlimePlantType.TALL_GRASS);
          }

          plantState = plantState.func_177226_a(BlockTallSlimeGrass.FOLIAGE, state.func_177229_b(FOLIAGE));

          if (TinkerWorld.slimeGrassTall.func_180671_f(worldIn, blockpos2, plantState))
          {
            worldIn.func_180501_a(blockpos2, plantState, 3);
          }
        }

        ++i;
        break;
      }
    }
  }

  @Override
  public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
    if(worldIn.field_72995_K) {
      return;
    }

    if (worldIn.func_175671_l(pos.func_177984_a()) < 4 && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c().getLightOpacity(worldIn, pos.func_177984_a()) > 2)
    {
      // convert grass back to dirt of the corresponding type
      worldIn.func_175656_a(pos, getDirtState(state));
    }
    else
    {
      // spread to surrounding blocks
      if (worldIn.func_175671_l(pos.func_177984_a()) >= 9)
      {
        for (int i = 0; i < 4; ++i)
        {
          BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
          Block block = worldIn.func_180495_p(pos1.func_177984_a()).func_177230_c();
          IBlockState state1 = worldIn.func_180495_p(pos1);

          if(worldIn.func_175671_l(pos1.func_177984_a()) >= 4 && block.getLightOpacity(worldIn, pos1.func_177984_a()) <= 2) {
            convert(worldIn, pos1, state1, state.func_177229_b(FOLIAGE));
          }
        }
      }
    }
  }

  public void convert(World world, BlockPos pos, IBlockState state, FoliageType foliageType) {
    IBlockState newState = getStateFromDirt(state);
    if(newState != null) {
      world.func_175656_a(pos, newState.func_177226_a(FOLIAGE, foliageType));
    }
  }

  @Override
  protected BlockState func_180661_e() {
    return new BlockState(this, TYPE, FOLIAGE, BlockGrass.field_176498_a);
  }

  @Override
  public IBlockState func_176203_a(int meta) {
    if(meta > 14) meta = 0;

    return this.func_176223_P().func_177226_a(TYPE, DirtType.values()[meta%5]).func_177226_a(FOLIAGE, FoliageType.values()[meta/5]);
  }

  @Override
  public int func_176201_c(IBlockState state) {
    DirtType type = state.func_177229_b(TYPE);
    FoliageType grass = state.func_177229_b(FOLIAGE);

    //type goes from 0-5, grass goes from 0-2 resulting in 0-5, 6-10, 11-15
    return type.ordinal() + grass.ordinal()*5;
  }

  @Override
  public int func_180651_a(IBlockState state) {
    DirtType type = state.func_177229_b(TYPE);
    if(type == DirtType.VANILLA)
      return 0;

    return getDirtState(state).func_177229_b(BlockSlimeDirt.TYPE).getMeta();
  }

  @Override
  public Item func_180660_a(IBlockState state, Random rand, int fortune) {
    return Item.func_150898_a(getDirtState(state).func_177230_c());
  }

  @Override
  public ItemStack getPickBlock(MovingObjectPosition target, World world, BlockPos pos, EntityPlayer player) {
    return this.func_180643_i(world.func_180495_p(pos));
  }

  /** Returns the blockstate for the dirt underneath the grass */
  public IBlockState getDirtState(IBlockState grassState) {
    DirtType type = grassState.func_177229_b(TYPE);
    switch(type) {
      case VANILLA:
        return Blocks.field_150346_d.func_176223_P();
      case GREEN:
        return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.GREEN.getMeta());
      case BLUE:
        return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.BLUE.getMeta());
      case PURPLE:
        return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.PURPLE.getMeta());
      case MAGMA:
        return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.MAGMA.getMeta());
    }
    return TinkerWorld.slimeDirt.func_176203_a(BlockSlimeDirt.DirtType.GREEN.getMeta());
  }

  /** Returns the grass blockstate for the given dirt type or null */
  public IBlockState getStateFromDirt(IBlockState dirtState) {
    // vanilla dirt?
    if(dirtState.func_177230_c() == Blocks.field_150346_d && dirtState.func_177229_b(BlockDirt.field_176386_a) == BlockDirt.DirtType.DIRT) {
      return this.func_176223_P().func_177226_a(TYPE, DirtType.VANILLA);
    }
    // slimedirt block?
    if(dirtState.func_177230_c() == TinkerWorld.slimeDirt) {
      // green slimedirt
      if(dirtState.func_177229_b(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.GREEN) {
        return this.func_176223_P().func_177226_a(TYPE, DirtType.GREEN);
      }
      // blue slimedirt
      else if(dirtState.func_177229_b(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.BLUE) {
        return this.func_176223_P().func_177226_a(TYPE, DirtType.BLUE);
      }
      // purple slimedirt
      else if(dirtState.func_177229_b(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.PURPLE) {
        return this.func_176223_P().func_177226_a(TYPE, DirtType.PURPLE);
      }
      // magma slimedirt
      else if(dirtState.func_177229_b(BlockSlimeDirt.TYPE) == BlockSlimeDirt.DirtType.MAGMA) {
        return this.func_176223_P().func_177226_a(TYPE, DirtType.MAGMA);
      }
    }

    return null;
  }

  @Override
  public boolean canSustainPlant(IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
    // can sustain both slimeplants and normal plants
    return plantable.getPlantType(world, pos) == TinkerWorld.slimePlantType || plantable.getPlantType(world, pos) == EnumPlantType.Plains;
  }

  @Override
  public int func_149635_D() {
    return SlimeColorizer.colorBlue;
  }

  // Used for the item
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180644_h(IBlockState state) {
    FoliageType foliageType = state.func_177229_b(FOLIAGE);
    return SlimeColorizer.getColorStatic(foliageType);
  }

  // Used for the block in world
  @SideOnly(Side.CLIENT)
  @Override
  public int func_180662_a(IBlockAccess worldIn, BlockPos pos, int renderPass) {
    IBlockState state = worldIn.func_180495_p(pos);
    if(state.func_177230_c() != this) return func_149635_D();

    FoliageType foliageType = state.func_177229_b(FOLIAGE);
    return SlimeColorizer.getColorForPos(pos, foliageType);
  }

  public enum FoliageType implements IStringSerializable, EnumBlock.IEnumMeta {
    BLUE,
    PURPLE,
    ORANGE;

    public static FoliageType getValFromMeta(int meta) {
      if(meta < 0 || meta >= values().length) {
        meta = 0;
      }

      return values()[meta];
    }

    @Override
    public int getMeta() {
      return ordinal();
    }

    @Override
    public String func_176610_l() {
      return this.toString();
    }
  }

  public enum DirtType implements IStringSerializable {
    VANILLA,
    GREEN,
    BLUE,
    PURPLE,
    MAGMA;

    @Override
    public String func_176610_l() {
      return this.toString();
    }
  }
}
