package slimeknights.tconstruct.tools.traits;

import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.PlayerEvent;

import slimeknights.tconstruct.library.traits.AbstractTrait;

/**
 * Increases mining speed in water and during rain
 */
public class TraitAquadynamic extends AbstractTrait {

  public TraitAquadynamic() {
    super("aquadynamic", EnumChatFormatting.AQUA);
  }

  @Override
  public void miningSpeed(ItemStack tool, PlayerEvent.BreakSpeed event) {
    float coeff = 1f;
    // is the player in water?
    if(event.entityPlayer.func_70090_H()) {
      coeff += 5.5f; // being in water causes speed to be 1/5th. These values work fine.
    }
    // is it raining?
    if(event.entityPlayer.field_70170_p.func_72896_J()) {
      coeff += event.entityPlayer.field_70170_p.func_180494_b(event.entityPlayer.func_180425_c()).func_76727_i()/1.6f;
    }

    event.newSpeed += event.originalSpeed * coeff;
  }
}
