package slimeknights.tconstruct.tools.inventory;

import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.tileentity.TileEntity;

import slimeknights.mantle.inventory.BaseContainer;

public class ContainerSideInventory<T extends TileEntity & IInventory> extends BaseContainer<T> {
  public final int columns;
  public final int slotCount;

  public ContainerSideInventory(T tile, IInventory inventory, int x, int y, int columns) {
    super(tile);

    this.columns = columns;
    this.slotCount = inventory.func_70302_i_();

    int rows = inventory.func_70302_i_() / columns;
    if(inventory.func_70302_i_() % columns != 0)
      rows++;

    int index = 0;
    for(int r = 0; r < rows; r++) {
      for(int c = 0; c < columns; c++) {
        if(index >= inventory.func_70302_i_())
          break;
        this.func_75146_a(createSlot(inventory, index, x + c*18, y + r*18));
        index++;
      }
    }
  }

  protected Slot createSlot(IInventory inventory, int index, int x, int y) {
    return new Slot(inventory, index, x, y);
  }

  public int getSlotCount() { return slotCount; }

  public int getSizeInventory() {
    return tile.func_70302_i_();
  }
}
