package slimeknights.tconstruct.tools.client;

import com.google.common.collect.Lists;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import org.lwjgl.input.Keyboard;
import org.lwjgl.util.Point;

import java.io.IOException;
import java.util.List;
import java.util.Set;

import slimeknights.mantle.client.gui.GuiElement;
import slimeknights.mantle.client.gui.GuiElementScalable;
import slimeknights.mantle.client.gui.GuiModule;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.TinkerRegistryClient;
import slimeknights.tconstruct.library.Util;
import slimeknights.tconstruct.library.client.ToolBuildGuiInfo;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.modifiers.ModifierNBT;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.tools.client.module.GuiButtonsToolStation;
import slimeknights.tconstruct.tools.client.module.GuiInfoPanel;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.inventory.ContainerToolStation;
import slimeknights.tconstruct.tools.inventory.SlotToolStationIn;
import slimeknights.tconstruct.tools.network.ToolStationSelectionPacket;
import slimeknights.tconstruct.tools.network.ToolStationTextPacket;
import slimeknights.tconstruct.tools.tileentity.TileToolStation;

@SideOnly(Side.CLIENT)
public class GuiToolStation extends GuiTinkerStation {

  private static final ResourceLocation BACKGROUND = Util.getResource("textures/gui/toolstation.png");

  private static final GuiElement TextFieldActive = new GuiElement(0, 210, 102, 12, 256, 256);
  private static final GuiElement ItemCover = new GuiElement(176, 18, 80, 64);
  private static final GuiElement SlotBackground = new GuiElement(176, 0, 18, 18);
  private static final GuiElement SlotBorder = new GuiElement(194, 0, 18, 18);

  private static final GuiElement SlotSpaceTop = new GuiElement(0, 174 + 2, 18, 2);
  private static final GuiElement SlotSpaceBottom = new GuiElement(0, 174, 18, 2);
  private static final GuiElement PanelSpaceL = new GuiElement(0, 174, 5, 4);
  private static final GuiElement PanelSpaceR = new GuiElement(9, 174, 9, 4);

  private static final GuiElement BeamLeft = new GuiElement(0, 180, 2, 7);
  private static final GuiElement BeamRight = new GuiElement(131, 180, 2, 7);
  private static final GuiElementScalable BeamCenter = new GuiElementScalable(2, 180, 129, 7);

  public static final int Column_Count = 5;
  private static final int Table_slot_count = 6;

  protected GuiElement buttonDecorationTop = SlotSpaceTop;
  protected GuiElement buttonDecorationBot = SlotSpaceBottom;
  protected GuiElement panelDecorationL = PanelSpaceL;
  protected GuiElement panelDecorationR = PanelSpaceR;

  protected GuiElement beamL = new GuiElement(0, 0, 0, 0);
  protected GuiElement beamR = new GuiElement(0, 0, 0, 0);
  protected GuiElementScalable beamC = new GuiElementScalable(0, 0, 0, 0);

  protected GuiButtonsToolStation buttons;
  protected int activeSlots; // how many of the available slots are active

  public GuiTextField textField;

  protected GuiInfoPanel toolInfo;
  protected GuiInfoPanel traitInfo;

  public ToolBuildGuiInfo currentInfo = GuiButtonRepair.info;


  public GuiToolStation(InventoryPlayer playerInv, World world, BlockPos pos, TileToolStation tile) {
    super(world, pos, (ContainerTinkerStation) tile.createContainer(playerInv, world, pos));

    buttons = new GuiButtonsToolStation(this, field_147002_h);
    this.addModule(buttons);
    toolInfo = new GuiInfoPanel(this, field_147002_h);
    this.addModule(toolInfo);
    traitInfo = new GuiInfoPanel(this, field_147002_h);
    this.addModule(traitInfo);

    toolInfo.yOffset = 5;
    traitInfo.yOffset = toolInfo.field_147000_g + 9;

    this.field_147000_g = 174;

    wood();
  }

  @Override
  public void func_73866_w_() {
    super.func_73866_w_();
    Keyboard.enableRepeatEvents(true);

    // workaround to line up the tabs on switching even though the GUI is a tad higher
    this.field_147009_r += 4;
    this.cornerY += 4;

    // todo: sync text via network
    textField = new GuiTextField(0, field_146289_q, cornerX + 70, cornerY + 7, 92, 12);
    //textField.setFocused(true);
    //textField.setCanLoseFocus(false);
    textField.func_146185_a(false);
    textField.func_146203_f(40);

    buttons.xOffset = -2;
    buttons.yOffset = beamC.h + buttonDecorationTop.h;
    toolInfo.xOffset = 2;
    toolInfo.yOffset = beamC.h + panelDecorationL.h;
    traitInfo.xOffset = toolInfo.xOffset;
    traitInfo.yOffset = toolInfo.yOffset + toolInfo.field_147000_g + 4;

    for(GuiModule module : modules) {
      module.field_147009_r += 4;
    }

    updateGUI();
  }

  @Override
  public void func_146281_b() {
    super.func_146281_b();
    Keyboard.enableRepeatEvents(false);
  }

  public Set<ToolCore> getBuildableItems() {
    return TinkerRegistry.getToolStationCrafting();
  }

  public void onToolSelection(ToolBuildGuiInfo info) {
    activeSlots = Math.min(info.positions.size(), Table_slot_count);
    currentInfo = info;

    ToolCore tool = null;

    if(info.tool != null && info.tool.func_77973_b() instanceof ToolCore) {
      tool = (ToolCore) info.tool.func_77973_b();
    }

    ((ContainerToolStation) field_147002_h).setToolSelection(tool, activeSlots);
    // update the server (and others)
    TinkerNetwork.sendToServer(new ToolStationSelectionPacket(tool, activeSlots));
    updateGUI();
  }

  public void onToolSelectionPacket(ToolStationSelectionPacket packet) {
    ToolBuildGuiInfo info = TinkerRegistryClient.getToolBuildInfoForTool(packet.tool);
    if(info == null) {
      info = GuiButtonRepair.info;
    }
    activeSlots = packet.activeSlots;
    currentInfo = info;

    buttons.setSelectedButtonByTool(currentInfo.tool);

    updateGUI();
  }

  public void updateGUI() {
    int i;
    for(i = 0; i < activeSlots; i++) {
      Point point = currentInfo.positions.get(i);

      Slot slot = field_147002_h.func_75139_a(i);
      slot.field_75223_e = point.getX();
      slot.field_75221_f = point.getY();
    }

    // remaining slots
    int stillFilled = 0;
    for(; i < Table_slot_count; i++) {
      Slot slot = field_147002_h.func_75139_a(i);

      if(slot.func_75216_d()) {
        slot.field_75223_e = 87 + 20 * stillFilled;
        slot.field_75221_f = 62;
        stillFilled++;
      }
      else {
        // todo: slot.disable
        slot.field_75223_e = 0;
        slot.field_75221_f = 0;
      }
    }

    updateDisplay();
  }

  @Override
  public void updateDisplay() {
    // tool info of existing or tool to build
    ContainerToolStation container = (ContainerToolStation) field_147002_h;
    ItemStack toolStack = container.getResult();
    if(toolStack == null) toolStack = field_147002_h.func_75139_a(0).func_75211_c();

    // current tool to build or repair/modify
    if(toolStack != null && toolStack.func_77973_b() instanceof ToolCore) {
      ToolCore tool = (ToolCore) toolStack.func_77973_b();
      toolInfo.setCaption(tool.getLocalizedToolName());
      toolInfo.setText(tool.getInformation(toolStack));

      traitInfo.setCaption(StatCollector.func_74838_a("gui.toolstation.traits"));

      List<String> mods = Lists.newLinkedList();
      List<String> tips = Lists.newLinkedList();
      NBTTagList tagList = TagUtil.getModifiersTagList(toolStack);
      for(int i = 0; i < tagList.func_74745_c(); i++) {
        NBTTagCompound tag = tagList.func_150305_b(i);
        ModifierNBT data = ModifierNBT.readTag(tag);

        // get matching modifier
        IModifier modifier = TinkerRegistry.getModifier(data.identifier);
        if(modifier == null || modifier.isHidden()) {
          continue;
        }

        mods.add(data.getColorString() + modifier.getTooltip(tag, true));
        tips.add(data.getColorString() + modifier.getLocalizedDesc());
      }

      if(mods.isEmpty()) {
        mods.add(StatCollector.func_74838_a("gui.toolstation.noTraits"));
      }

      traitInfo.setText(mods, tips);
    }
    // repair info
    else if(currentInfo.tool == null) {
      toolInfo.setCaption(StatCollector.func_74838_a("gui.toolstation.repair"));
      toolInfo.setText();

      traitInfo.setCaption(null);
      String c = EnumChatFormatting.DARK_GRAY.toString();
      String[] art = new String[] {
          c + "",
          c + "",
          c + "       .",
          c + "     /( _________",
          c + "     |  >:=========`",
          c + "     )(  ",
          c + "     \"\""
      };
      traitInfo.setText(art);
    }
    // tool build info
    else {
      ToolCore tool = (ToolCore)currentInfo.tool.func_77973_b();
      toolInfo.setCaption(tool.getLocalizedToolName());
      toolInfo.setText(tool.getLocalizedDescription());

      // Components
      List<String> text = Lists.newLinkedList();
      List<PartMaterialType> pms = tool.getRequiredComponents();
      for(int i = 0; i < pms.size(); i++) {
        PartMaterialType pmt = pms.get(i);
        StringBuilder sb = new StringBuilder();

        ItemStack slotStack = container.func_75139_a(i).func_75211_c();
        if(!pmt.isValid(slotStack)) {
          sb.append(EnumChatFormatting.RED);

          // is an item in the slot?
          if(slotStack != null && slotStack.func_77973_b() instanceof IToolPart) {
            if(pmt.isValidItem((IToolPart) slotStack.func_77973_b())) {
              // the item has an invalid material
              warning(Util.translate("gui.error.wrong_material_part"));
            }
          }
        }

        sb.append(" * ");
        for(IToolPart part : pmt.getPossibleParts()) {
          if(part instanceof Item) {
            sb.append(((Item) part).func_77653_i(new ItemStack((Item) part)));
            sb.append("/");
          }
        }
        sb.deleteCharAt(sb.length()-1); // removes last '/'
        text.add(sb.toString());
      }
      traitInfo.setCaption(StatCollector.func_74838_a("gui.toolstation.components"));
      traitInfo.setText(text.toArray(new String[text.size()]));
    }
  }

  @Override
  protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
    super.func_73864_a(mouseX, mouseY, mouseButton);
    textField.func_146192_a(mouseX, mouseY, mouseButton);
  }

  @Override
  protected void func_73869_a(char typedChar, int keyCode) throws IOException {
    if(!textField.func_146206_l()) {
      super.func_73869_a(typedChar, keyCode);
    }
    else {
      if(keyCode == 1) {
        this.field_146297_k.field_71439_g.func_71053_j();
      }

      textField.func_146201_a(typedChar, keyCode);
      TinkerNetwork.sendToServer(new ToolStationTextPacket(textField.func_146179_b()));
      ((ContainerToolStation)container).setToolName(textField.func_146179_b());
    }
  }

  @Override
  public void func_73876_c() {
    super.func_73876_c();
    textField.func_146178_a();
  }

  @Override
  public void func_146977_a(Slot slotIn) {
    // don't draw dormant slots with no item
    if(slotIn instanceof SlotToolStationIn && ((SlotToolStationIn) slotIn).isDormant() && !slotIn.func_75216_d())
      return;

    super.func_146977_a(slotIn);
  }

  @Override
  protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    drawBackground(BACKGROUND);

    if(textField.func_146206_l()) {
      TextFieldActive.draw(cornerX + 68, cornerY + 6);
    }

    // draw textfield
    textField.func_146194_f();

    //int xOff = 3;
    //int yOff = 6;

    int x = 0;
    int y = 0;

    // draw the item background
    final float scale = 3.7f;
    final float xOff = 10f;
    final float yOff = 22f;
    GlStateManager.func_179109_b(xOff, yOff, 0);
    GlStateManager.func_179152_a(scale, scale, 1.0f);
    {
      int logoX = (int) (this.cornerX / scale);
      int logoY = (int) (this.cornerY / scale);

      if(currentInfo != null) {
        if(currentInfo.tool != null) {
          field_146296_j.func_175042_a(currentInfo.tool, logoX, logoY);
        }
        else if(currentInfo == GuiButtonRepair.info) {
          this.field_146297_k.func_110434_K().func_110577_a(ICONS);
          ICON_Anvil.draw(logoX, logoY);
        }
      }
    }
    GlStateManager.func_179152_a(1f / scale, 1f / scale, 1.0f);
    GlStateManager.func_179109_b(-xOff, -yOff, 0);

    // rebind gui texture since itemstack drawing sets it to something else
    this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);

    // reset state after item drawing
    GlStateManager.func_179147_l();
    GlStateManager.func_179141_d();
    RenderHelper.func_74518_a();
    GlStateManager.func_179097_i();

    // draw the halftransparent "cover" over the item
    GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 0.82f);
    ItemCover.draw(this.cornerX + 7, this.cornerY + 18);

    // the slot backgrounds
    GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 0.28f);
    for(int i = 0; i < activeSlots; i++) {
      Slot slot = field_147002_h.func_75139_a(i);
      SlotBackground.draw(x + this.cornerX + slot.field_75223_e - 1, y + this.cornerY + slot.field_75221_f - 1);
    }

    // full opaque. Draw the borders of the slots
    GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
    for(int i = 0; i < Table_slot_count; i++) {
      Slot slot = field_147002_h.func_75139_a(i);
      if(slot instanceof SlotToolStationIn && (!((SlotToolStationIn) slot).isDormant() || slot.func_75216_d())) {
        SlotBorder.draw(
            x + this.cornerX + slot.field_75223_e - 1, y + this.cornerY + slot.field_75221_f - 1);
      }
    }

    this.field_146297_k.func_110434_K().func_110577_a(ICONS);

    // slot logos
    if(currentInfo == GuiButtonRepair.info) {
      drawRepairSlotIcons();
    }
    else if(currentInfo.tool != null && currentInfo.tool.func_77973_b() instanceof TinkersItem) {
      for(int i = 0; i < activeSlots; i++) {
        Slot slot = field_147002_h.func_75139_a(i);
        if(!(slot instanceof SlotToolStationIn)) {
          continue;
        }

        ItemStack stack = ((SlotToolStationIn) slot).icon;
        if(stack == null) {
          continue;
        }

        field_146296_j.func_175042_a(stack,
                                     x + this.cornerX + slot.field_75223_e,
                                     y + this.cornerY + slot.field_75221_f);
      }
    }


    this.field_146297_k.func_110434_K().func_110577_a(BACKGROUND);
    x = buttons.field_147003_i - beamL.w;
    y = cornerY;
    // draw the beams at the top
    x += beamL.draw(x, y);
    x += beamC.drawScaledX(x, y, buttons.field_146999_f);
    beamR.draw(x, y);

    x = toolInfo.field_147003_i - beamL.w;
    x += beamL.draw(x, y);
    x += beamC.drawScaledX(x, y, toolInfo.field_146999_f);
    beamR.draw(x, y);

    // draw the decoration for the buttons
    for(Object o : buttons.field_146292_n) {
      GuiButton button = (GuiButton) o;

      buttonDecorationTop.draw(button.field_146128_h, button.field_146129_i - buttonDecorationTop.h);
      // don't draw the bottom for the buttons in the last row
      if(button.field_146127_k < buttons.field_146292_n.size() - Column_Count) {
        buttonDecorationBot.draw(button.field_146128_h, button.field_146129_i + button.field_146121_g);
      }
    }

    // draw the decorations for the panels
    panelDecorationL.draw(toolInfo.field_147003_i + 5, toolInfo.field_147009_r - panelDecorationL.h);
    panelDecorationR.draw(toolInfo.guiRight() - 5 - panelDecorationR.w, toolInfo.field_147009_r - panelDecorationR.h);
    panelDecorationL.draw(traitInfo.field_147003_i + 5, traitInfo.field_147009_r - panelDecorationL.h);
    panelDecorationR.draw(traitInfo.guiRight() - 5 - panelDecorationR.w, traitInfo.field_147009_r - panelDecorationR.h);

    GlStateManager.func_179126_j();

    // continue as usual and hope that the drawing state is not completely wrecked
    super.func_146976_a(partialTicks, mouseX, mouseY);
  }

  protected void drawRepairSlotIcons() {
    for(int i = 0; i < activeSlots; i++) {
      drawRepairSlotIcon(i);
    }
  }

  protected void drawRepairSlotIcon(int i) {
    GuiElement icon = null;
    Slot slot = field_147002_h.func_75139_a(i);
    // only empty solts get the logo since something else than the displayed thing might be in there.
    // which would look weird.
    if(slot.func_75216_d()) {
      return;
    }

    if(i == 0) {
      icon = ICON_Pickaxe;
    }
    else if(i == 1) {
      icon = ICON_Dust;
    }
    else if(i == 2) {
      icon = ICON_Lapis;
    }
    else if(i == 3) {
      icon = ICON_Ingot;
    }
    else if(i == 4) {
      icon = ICON_Gem;
    }
    else if(i == 5) {
      icon = ICON_Quartz;
    }

    if(icon != null) {
      drawIconEmpty(slot, icon);
    }
  }

  protected void wood() {
    toolInfo.wood();
    traitInfo.wood();

    buttonDecorationTop = SlotSpaceTop.shift(SlotSpaceTop.w, 0);
    buttonDecorationBot = SlotSpaceBottom.shift(SlotSpaceBottom.w, 0);
    panelDecorationL = PanelSpaceL.shift(18, 0);
    panelDecorationR = PanelSpaceR.shift(18, 0);

    buttons.wood();

    beamL = BeamLeft;
    beamR = BeamRight;
    beamC = BeamCenter;
  }

  protected void metal() {
    toolInfo.metal();
    traitInfo.metal();

    buttonDecorationTop = SlotSpaceTop.shift(SlotSpaceTop.w * 2, 0);
    buttonDecorationBot = SlotSpaceBottom.shift(SlotSpaceBottom.w * 2, 0);
    panelDecorationL = PanelSpaceL.shift(18 * 2, 0);
    panelDecorationR = PanelSpaceR.shift(18 * 2, 0);

    buttons.metal();

    beamL = BeamLeft.shift(0, BeamLeft.h);
    beamR = BeamRight.shift(0, BeamRight.h);
    beamC = BeamCenter.shift(0, BeamCenter.h);
  }

  @Override
  public void error(String message) {
    toolInfo.setCaption(StatCollector.func_74838_a("gui.error"));
    toolInfo.setText(message);
    traitInfo.setCaption(null);
    traitInfo.setText();
  }

  @Override
  public void warning(String message) {
    toolInfo.setCaption(StatCollector.func_74838_a("gui.warning"));
    toolInfo.setText(message);
    traitInfo.setCaption(null);
    traitInfo.setText();
  }
}
