package slimeknights.tconstruct.library.client.texture;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

import slimeknights.tconstruct.library.client.RenderUtil;

public class TextureColoredTexture extends AbstractColoredTexture {

  protected final TextureAtlasSprite addTexture;
  protected final String addTextureLocation;
  protected int[][] textureData;
  protected int textureW;
  protected int textureH;
  protected float scale;
  protected int offsetX = 0;
  protected int offsetY = 0;

  public boolean stencil = false;

  public TextureColoredTexture(String addTextureLocation, TextureAtlasSprite baseTexture,
                               String spriteName) {
    super(baseTexture, spriteName);
    this.addTextureLocation = addTextureLocation;
    this.addTexture = null;
  }

  public TextureColoredTexture(TextureAtlasSprite addTexture, TextureAtlasSprite baseTexture,
                               String spriteName) {
    super(baseTexture, spriteName);
    this.addTextureLocation = addTexture.func_94215_i();
    this.addTexture = addTexture;
  }

  @Override
  protected int colorPixel(int pixel, int mipmap, int pxCoord) {
    int a = RenderUtil.alpha(pixel);
    if(a == 0) {
      return pixel;
    }

    if(textureData == null) {
      loadData();
    }


    int texCoord = pxCoord;
    if(field_130223_c > textureW) {
      int texX = (pxCoord % field_130223_c) % textureW;
      int texY = (pxCoord / field_130224_d) % textureH;
      texCoord = texY * textureW + texX;
    }
    int c = textureData[mipmap][texCoord];

    // multiply in the color
    int r = RenderUtil.red(c);
    int b = RenderUtil.blue(c);
    int g = RenderUtil.green(c);

    if(!stencil) {
      r = mult(mult(r, RenderUtil.red(pixel)), RenderUtil.red(pixel));
      g = mult(mult(g, RenderUtil.green(pixel)), RenderUtil.green(pixel));
      b = mult(mult(b, RenderUtil.blue(pixel)), RenderUtil.blue(pixel));
    }
    return RenderUtil.compose(r, g, b, a);
  }

  protected void loadData() {
    if(addTexture != null && addTexture.func_110970_k() > 0) {
      textureData = addTexture.func_147965_a(0);
      scale = (float)addTexture.func_94211_a() / (float)this.field_130223_c;
      textureW = addTexture.func_94211_a();
      textureH = addTexture.func_94216_b();
    }
    else {
      // we need to keep the sizes, otherwise the secondary texture might set our size to a different value
      // since it uses the same loading code as the main texture
      // read: 32x32 block textures with 16x16 tool textures = stuff goes boom
      int w = this.field_130223_c;
      int h = this.field_130224_d;
      textureData = backupLoadTexture(new ResourceLocation(addTextureLocation),
                                      Minecraft.func_71410_x().func_110442_L());

      scale = (float)this.field_130223_c / (float)w;
      textureW = this.field_130223_c;
      textureH = this.field_130224_d;
      this.field_130223_c = w;
      this.field_130224_d = h;
    }
  }

  public void setOffset(int x, int y) {
    offsetX = x;
    offsetY = y;
  }

  protected int coord2(int x, int y) {
    return y * textureW + x;
  }
}
