package slimeknights.tconstruct.tools.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import java.util.List;

import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.network.EntityMovementChangePacket;

// BattleSign Ability: Blocks more damage and can reflect projectiles. The ultimate defensive weapon.
public class BattleSign extends BroadSword {

  public BattleSign() {
    super(PartMaterialType.handle(TinkerTools.toolRod),
          PartMaterialType.head(TinkerTools.signHead));
  }

  @Override
  public int attackSpeed() {
    return 0;
  }

  @Override
  public float damagePotential() {
    return 0.86f;
  }

  // Extra damage reduction when blocking with a battlesign
  @SubscribeEvent(priority = EventPriority.LOW) // lower priority so we get called later since we change tool NBT
  public void reducedDamageBlocked(LivingHurtEvent event) {
    // don't affect unblockable or magic damage or explosion damage
    // projectiles are handled in LivingAttackEvent
    if(event.source.func_76363_c() || event.source.func_82725_o() || event.source.func_94541_c() || event.source.func_76352_a() || event.isCanceled()) {
      return;
    }
    if(!shouldBlockDamage(event.entityLiving)) {
      return;
    }

    EntityPlayer player = (EntityPlayer) event.entityLiving;
    ItemStack battlesign = player.func_71045_bC();

    // got hit by something: reduce damage
    int damage = event.ammount < 2f ? 1 : Math.round(event.ammount/2f);
    // reduce damage. After this event the damage will be halved again because we're blocking so we have to factor this in
    event.ammount *= 0.7f;

    // reflect damage
    if(event.source.func_76346_g() != null) {
      event.source.func_76346_g().func_70097_a(DamageSource.func_92087_a(player), event.ammount/2f);
      damage = damage * 3 / 2;
    }
    ToolHelper.damageTool(battlesign, damage, player);
  }

  @SubscribeEvent
  public void reflectProjectiles(LivingAttackEvent event) {
    // only blockable projectile damage
    if(event.source.func_76363_c() || !event.source.func_76352_a()) {
      return;
    }
    if(!shouldBlockDamage(event.entityLiving)) {
      return;
    }

    EntityPlayer player = (EntityPlayer) event.entityLiving;
    ItemStack battlesign = player.func_71045_bC();

    // ensure the player is looking at the projectile (aka not getting shot into the back)
    Entity projectile = event.source.func_76364_f();
    Vec3 motion = new Vec3(projectile.field_70159_w, projectile.field_70181_x, projectile.field_70179_y);
    Vec3 look = player.func_70040_Z();

    // this gives a factor of how much we're looking at the incoming arrow
    double strength = -look.func_72430_b(motion.func_72432_b());
    // we're looking away. oh no.
    if(strength < 0.1)
      return;

    // caught that bastard! block it!
    event.setCanceled(true);

    // and return it to the sender
    // calc speed of the projectile
    double speed = projectile.field_70159_w*projectile.field_70159_w + projectile.field_70181_x*projectile.field_70181_x + projectile.field_70179_y*projectile.field_70179_y;
    speed = Math.sqrt(speed);
    speed += 0.2f; // we add a bit speed

    // and redirect it to where the player is looking
    projectile.field_70159_w = look.field_72450_a * speed;
    projectile.field_70181_x = look.field_72448_b * speed;
    projectile.field_70179_y = look.field_72449_c * speed;

    projectile.field_70177_z = (float)(Math.atan2(projectile.field_70159_w, projectile.field_70179_y) * 180.0D / Math.PI);
    projectile.field_70125_A = (float)(Math.atan2(projectile.field_70181_x, speed) * 180.0D / Math.PI);

    // notify clients from change, otherwise people will get veeeery confused
    TinkerNetwork.sendToAll(new EntityMovementChangePacket(projectile));

    // special treatement for arrows
    if(projectile instanceof EntityArrow) {
      ((EntityArrow) projectile).field_70250_c = player;

      // the inverse is done when the event is cancelled in arrows etc.
      // we reverse it so it has no effect. yay
      projectile.field_70159_w /= -0.10000000149011612D;
      projectile.field_70181_x /= -0.10000000149011612D;
      projectile.field_70179_y /= -0.10000000149011612D;
    }

    // use durability equal to the damage prevented
    ToolHelper.damageTool(battlesign, (int)event.ammount, player);
  }

  protected boolean shouldBlockDamage(Entity entity) {
    // hit entity is a player?
    if(!(entity instanceof EntityPlayer)) {
      return false;
    }
    EntityPlayer player = (EntityPlayer) entity;
    // needs to be blocking with a battlesign
    if(!player.func_70632_aY() || player.func_71045_bC().func_77973_b() != this) {
      return false;
    }

    // broken battlesign.
    if(ToolHelper.isBroken(player.func_71045_bC())) {
      return false;
    }

    return true;
  }

  @Override
  public NBTTagCompound buildTag(List<Material> materials) {
    return buildDefaultTag(materials).get();
  }
}
