package slimeknights.tconstruct.smeltery.item;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidTank;

import java.util.List;

import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.tconstruct.library.Util;

public class ItemTank extends ItemBlockMeta {

  public ItemTank(Block block) {
    super(block);
  }

  @Override
  public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
    super.func_77624_a(stack, playerIn, tooltip, advanced);

    if(stack.func_77942_o()) {
      FluidTank tank = new FluidTank(0);
      tank.readFromNBT(stack.func_77978_p());
      if(tank.getFluidAmount() > 0) {
        tooltip.add(Util.translateFormatted("tooltip.tank.fluid", tank.getFluid().getLocalizedName()));
        tooltip.add(Util.translateFormatted("tooltip.tank.amount", tank.getFluid().amount));
      }
    }
  }
}
