/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.inventory;

import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import slimeknights.mantle.inventory.BaseContainer;
import slimeknights.mantle.network.AbstractPacket;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.common.TinkerNetwork;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.modifiers.TinkerGuiException;
import slimeknights.tconstruct.library.tinkering.IModifyable;
import slimeknights.tconstruct.library.tinkering.IRepairable;
import slimeknights.tconstruct.library.tinkering.PartMaterialType;
import slimeknights.tconstruct.library.tinkering.TinkersItem;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolBuilder;
import slimeknights.tconstruct.tools.client.GuiToolStation;
import slimeknights.tconstruct.tools.inventory.ContainerTinkerStation;
import slimeknights.tconstruct.tools.inventory.SlotToolStationIn;
import slimeknights.tconstruct.tools.inventory.SlotToolStationOut;
import slimeknights.tconstruct.tools.network.ToolStationSelectionPacket;
import slimeknights.tconstruct.tools.network.ToolStationTextPacket;
import slimeknights.tconstruct.tools.tileentity.TileToolStation;

public class ContainerToolStation
extends ContainerTinkerStation<TileToolStation> {
    protected SlotToolStationOut out;
    protected ToolCore selectedTool;
    protected int activeSlots;
    public String toolName;

    public ContainerToolStation(InventoryPlayer playerInventory, TileToolStation tile) {
        super(tile);
        int i;
        for (i = 0; i < tile.getSizeInventory(); ++i) {
            this.addSlotToContainer(new SlotToolStationIn((IInventory)tile, i, 0, 0, (Container)this));
        }
        this.out = new SlotToolStationOut(i, 124, 38, this);
        this.addSlotToContainer(this.out);
        this.addPlayerInventory(playerInventory, 8, 92);
        this.onCraftMatrixChanged(null);
    }

    public ItemStack getResult() {
        return this.out.getStack();
    }

    protected void syncNewContainer(EntityPlayerMP player) {
        this.activeSlots = ((TileToolStation)this.tile).getSizeInventory();
        TinkerNetwork.sendTo((AbstractPacket)new ToolStationSelectionPacket(null, ((TileToolStation)this.tile).getSizeInventory()), player);
    }

    protected void syncWithOtherContainer(BaseContainer<TileToolStation> otherContainer, EntityPlayerMP player) {
        this.syncWithOtherContainer((ContainerToolStation)otherContainer, player);
    }

    protected void syncWithOtherContainer(ContainerToolStation otherContainer, EntityPlayerMP player) {
        this.setToolSelection(otherContainer.selectedTool, otherContainer.activeSlots);
        this.setToolName(otherContainer.toolName);
        TinkerNetwork.sendTo((AbstractPacket)new ToolStationSelectionPacket(otherContainer.selectedTool, otherContainer.activeSlots), player);
        if (otherContainer.toolName != null && !otherContainer.toolName.isEmpty()) {
            TinkerNetwork.sendTo((AbstractPacket)new ToolStationTextPacket(otherContainer.toolName), player);
        }
    }

    public void setToolSelection(ToolCore tool, int activeSlots) {
        if (activeSlots > ((TileToolStation)this.tile).getSizeInventory()) {
            activeSlots = ((TileToolStation)this.tile).getSizeInventory();
        }
        this.activeSlots = activeSlots;
        this.selectedTool = tool;
        for (int i = 0; i < ((TileToolStation)this.tile).getSizeInventory(); ++i) {
            Slot slot = (Slot)this.inventorySlots.get(i);
            if (!(slot instanceof SlotToolStationIn)) continue;
            SlotToolStationIn slotToolPart = (SlotToolStationIn)slot;
            slotToolPart.setRestriction(null);
            if (i >= activeSlots) {
                slotToolPart.deactivate();
            } else {
                List<PartMaterialType> pmts;
                slotToolPart.activate();
                if (tool != null && i < (pmts = tool.getRequiredComponents()).size()) {
                    slotToolPart.setRestriction(pmts.get(i));
                }
            }
            if (!this.world.isRemote) continue;
            slotToolPart.updateIcon();
        }
    }

    public void setToolName(String name) {
        GuiScreen screen;
        this.toolName = name;
        if (this.world.isRemote && (screen = Minecraft.getMinecraft().currentScreen) instanceof GuiToolStation) {
            ((GuiToolStation)screen).textField.setText(name);
        }
        if (this.out.getHasStack()) {
            if (name != null && !name.isEmpty()) {
                this.out.inventory.getStackInSlot(0).setStackDisplayName(name);
            } else {
                this.out.inventory.getStackInSlot(0).clearCustomName();
            }
        }
    }

    public void onCraftMatrixChanged(IInventory inventoryIn) {
        this.updateGUI();
        try {
            ItemStack result = this.repairTool(false);
            if (result == null) {
                result = this.replaceToolParts(false);
            }
            if (result == null) {
                result = this.modifyTool(false);
            }
            if (result == null) {
                result = this.buildTool();
            }
            this.out.inventory.setInventorySlotContents(0, result);
            this.updateGUI();
        }
        catch (TinkerGuiException e) {
            this.out.inventory.setInventorySlotContents(0, null);
            this.error(e.getMessage());
        }
        if (!this.world.isRemote) {
            WorldServer server = (WorldServer)this.world;
            for (EntityPlayer player : server.playerEntities) {
                if (player.openContainer == this || !(player.openContainer instanceof ContainerToolStation) || !this.sameGui((BaseContainer)((ContainerToolStation)player.openContainer))) continue;
                ((ContainerToolStation)player.openContainer).out.inventory.setInventorySlotContents(0, this.out.getStack());
            }
        }
    }

    public void onResultTaken(EntityPlayer playerIn, ItemStack stack) {
        boolean resultTaken = false;
        try {
            resultTaken = this.repairTool(true) != null || this.replaceToolParts(true) != null || this.modifyTool(true) != null;
        }
        catch (TinkerGuiException e) {
            e.printStackTrace();
        }
        if (resultTaken) {
            this.updateSlotsAfterToolAction();
        } else {
            ItemStack tool = this.buildTool();
            if (tool != null) {
                for (int i = 0; i < ((TileToolStation)this.tile).getSizeInventory(); ++i) {
                    ((TileToolStation)this.tile).decrStackSize(i, 1);
                }
                this.setToolName("");
            }
        }
        this.onCraftMatrixChanged(null);
        this.playCraftSound(playerIn);
    }

    protected void playCraftSound(EntityPlayer player) {
        player.worldObj.playSoundAtEntity((Entity)player, Sounds.saw, 0.8f, 0.8f + 0.4f * TConstruct.random.nextFloat());
    }

    private ItemStack repairTool(boolean remove) {
        ItemStack repairable = ((Slot)this.inventorySlots.get(0)).getStack();
        if (repairable == null || !(repairable.getItem() instanceof IRepairable)) {
            return null;
        }
        return ToolBuilder.tryRepairTool(this.getInputs(), repairable, remove);
    }

    private ItemStack replaceToolParts(boolean remove) throws TinkerGuiException {
        ItemStack tool = ((Slot)this.inventorySlots.get(0)).getStack();
        if (tool == null || !(tool.getItem() instanceof TinkersItem)) {
            return null;
        }
        return ToolBuilder.tryReplaceToolParts(tool, this.getInputs(), remove);
    }

    private ItemStack modifyTool(boolean remove) throws TinkerGuiException {
        ItemStack modifyable = ((Slot)this.inventorySlots.get(0)).getStack();
        if (modifyable == null || !(modifyable.getItem() instanceof IModifyable)) {
            return null;
        }
        return ToolBuilder.tryModifyTool(this.getInputs(), modifyable, remove);
    }

    private ItemStack buildTool() {
        ItemStack[] input = new ItemStack[((TileToolStation)this.tile).getSizeInventory()];
        for (int i = 0; i < input.length; ++i) {
            input[i] = ((TileToolStation)this.tile).getStackInSlot(i);
        }
        return ToolBuilder.tryBuildTool(input, this.toolName, this.getBuildableTools());
    }

    protected Set<ToolCore> getBuildableTools() {
        return TinkerRegistry.getToolStationCrafting();
    }

    private void updateSlotsAfterToolAction() {
        ((TileToolStation)this.tile).setInventorySlotContents(0, null);
        for (int i = 1; i < ((TileToolStation)this.tile).getSizeInventory(); ++i) {
            if (((TileToolStation)this.tile).getStackInSlot(i) == null || ((TileToolStation)this.tile).getStackInSlot((int)i).stackSize != 0) continue;
            ((TileToolStation)this.tile).setInventorySlotContents(i, null);
        }
    }

    private ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[((TileToolStation)this.tile).getSizeInventory() - 1];
        for (int i = 1; i < ((TileToolStation)this.tile).getSizeInventory(); ++i) {
            input[i - 1] = ((TileToolStation)this.tile).getStackInSlot(i);
        }
        return input;
    }

    public boolean canMergeSlot(ItemStack stack, Slot slot) {
        return slot != this.out && super.canMergeSlot(stack, slot);
    }
}

