/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TagUtil;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.tools.events.TinkerToolEvent;

public class ToolEvents {
    private static final Random random = new Random();
    public static final Set<ToolCore> smallTools = Sets.newHashSet();

    @SubscribeEvent
    public void onExtraBlockBreak(TinkerToolEvent.ExtraBlockBreak event) {
        if (TinkerTools.modHarvestWidth == null || TinkerTools.modHarvestHeight == null) {
            return;
        }
        NBTTagList modifiers = TagUtil.getBaseModifiersTagList(event.itemStack);
        boolean width = false;
        boolean height = false;
        for (int i = 0; i < modifiers.tagCount(); ++i) {
            String modId = modifiers.getStringTagAt(i);
            if (modId.equals(TinkerTools.modHarvestWidth.getIdentifier())) {
                width = true;
                continue;
            }
            if (!modId.equals(TinkerTools.modHarvestHeight.getIdentifier())) continue;
            height = true;
        }
        if (!width && !height) {
            return;
        }
        if (event.tool == TinkerTools.pickaxe || event.tool == TinkerTools.hatchet || event.tool == TinkerTools.shovel) {
            event.width = event.width + (width ? 1 : 0);
            event.height = event.height + (height ? 1 : 0);
        } else if (event.tool == TinkerTools.mattock) {
            int c = 0;
            if (width) {
                ++c;
            }
            if (height) {
                ++c;
            }
            event.width += c;
            event.height += c;
        } else if (event.tool == TinkerTools.hammer || event.tool == TinkerTools.excavator || event.tool == TinkerTools.lumberAxe) {
            event.width = event.width + (width ? 2 : 0);
            event.height = event.height + (height ? 2 : 0);
            event.distance = 3;
        }
    }

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        if (event.entityLiving instanceof EntitySkeleton && event.source.getEntity() instanceof EntityPlayer && ((EntitySkeleton)event.entityLiving).getSkeletonType() == 1) {
            float chance = 0.1f;
            chance += 0.05f + (float)EnchantmentHelper.getLootingModifier((EntityLivingBase)((EntityLivingBase)event.source.getEntity()));
            if (random.nextFloat() < chance) {
                EntityItem entityitem = new EntityItem(event.entityLiving.worldObj, event.entityLiving.posX, event.entityLiving.posY, event.entityLiving.posZ, TinkerCommons.matNecroticBone.copy());
                entityitem.setDefaultPickupDelay();
                event.drops.add(entityitem);
            }
        }
    }
}

